/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.checks.FunMatcherBuilderContext;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.visiting.KotlinFileVisitorKt;

@Rule(key="S5527")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\r\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0013\u0010\u0014\u001a\u00020\u0011*\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0013"}, d2={"Lorg/sonarsource/kotlin/checks/VerifiedServerHostnamesCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "function", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "kotlinFileContext", "", "visitNamedFunction", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "expression", "visitLambdaExpression", "(Lorg/jetbrains/kotlin/psi/KtLambdaExpression;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "Lorg/jetbrains/kotlin/psi/KtExpression;", "ktExpression", "", "onlyReturnsTrue", "(Lorg/jetbrains/kotlin/psi/KtExpression;)Z", "isTrueConstant", "Companion"})
public final class VerifiedServerHostnamesCheck
extends AbstractCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final FunMatcherImpl VERIFY_MATCHER = FunMatcherKt.FunMatcher$default(null, null, null, null, false, null, null, null, null, null, VerifiedServerHostnamesCheck::VERIFY_MATCHER$lambda$2, 1023, null);
    @NotNull
    private static final FunMatcherImpl HOSTNAME_VERIFIER_MATCHER = FunMatcherKt.FunMatcher$default(null, null, null, null, false, null, null, null, null, null, VerifiedServerHostnamesCheck::HOSTNAME_VERIFIER_MATCHER$lambda$3, 1023, null);
    @NotNull
    public static final String MESSAGE = "Enable server hostname verification on this SSL/TLS connection.";

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2, @NotNull KotlinFileContext kotlinFileContext) {
        List<KtExpression> listStatements;
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        if (VERIFY_MATCHER.matches(function2) && (listStatements = this.listStatements(function2)).size() == 1 && this.onlyReturnsTrue(listStatements.get(0))) {
            AbstractCheck abstractCheck = this;
            PsiElement psiElement = function2.getNameIdentifier();
            Intrinsics.checkNotNull(psiElement);
            AbstractCheck.reportIssue$default(abstractCheck, kotlinFileContext, psiElement, MESSAGE, null, null, 12, null);
        }
    }

    @Override
    public void visitLambdaExpression(@NotNull KtLambdaExpression expression, @NotNull KotlinFileContext kotlinFileContext) {
        block3: {
            Intrinsics.checkNotNullParameter(expression, "expression");
            Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
            KaFunctionCall<?> kaFunctionCall = ApiExtensionsKt.getParentCall(expression);
            if (kaFunctionCall == null) break block3;
            KaFunctionCall<?> it = kaFunctionCall;
            boolean bl = false;
            if (HOSTNAME_VERIFIER_MATCHER.matches((KaCallableMemberCall)it)) {
                List<KtExpression> listStatements;
                KtBlockExpression ktBlockExpression = expression.getBodyExpression();
                List<KtExpression> list = listStatements = ktBlockExpression != null ? ktBlockExpression.getStatements() : null;
                boolean bl2 = list != null ? list.size() == 1 : false;
                if (bl2) {
                    KtExpression ktExpression = listStatements.get(0);
                    Intrinsics.checkNotNullExpressionValue(ktExpression, "get(...)");
                    if (this.isTrueConstant(ktExpression)) {
                        AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)expression, MESSAGE, null, null, 12, null);
                    }
                }
            }
        }
    }

    private final boolean onlyReturnsTrue(KtExpression ktExpression) {
        boolean bl;
        if (ktExpression instanceof KtReturnExpression) {
            KtExpression ktExpression2 = ((KtReturnExpression)ktExpression).getReturnedExpression();
            bl = ktExpression2 != null ? this.isTrueConstant(ktExpression2) : false;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isTrueConstant(KtExpression $this$isTrueConstant) {
        boolean $i$f$withKaSession = false;
        KaSession kaSession = KotlinFileVisitorKt.getKaSession();
        Intrinsics.checkNotNull(kaSession);
        KaSession $this$isTrueConstant_u24lambda_u241 = kaSession;
        boolean bl = false;
        Boolean bl2 = ApiExtensionsKt.predictRuntimeBooleanValue($this$isTrueConstant);
        return bl2 != null ? bl2 : false;
    }

    private static final Unit VERIFY_MATCHER$lambda$2(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        $this$FunMatcher.setDefiningSupertype("javax.net.ssl.HostnameVerifier");
        $this$FunMatcher.setName("verify");
        return Unit.INSTANCE;
    }

    private static final Unit HOSTNAME_VERIFIER_MATCHER$lambda$3(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        $this$FunMatcher.setQualifier("okhttp3.OkHttpClient.Builder");
        $this$FunMatcher.setName("hostnameVerifier");
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\t\u0010\u0006\u001a\u0004\b\n\u0010\bR\u0014\u0010\f\u001a\u00020\u000b8\u0006X\u0087T\u00a2\u0006\u0006\n\u0004\b\f\u0010\r"}, d2={"Lorg/sonarsource/kotlin/checks/VerifiedServerHostnamesCheck$Companion;", "", "<init>", "()V", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "VERIFY_MATCHER", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "getVERIFY_MATCHER", "()Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "HOSTNAME_VERIFIER_MATCHER", "getHOSTNAME_VERIFIER_MATCHER", "", "MESSAGE", "Ljava/lang/String;"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FunMatcherImpl getVERIFY_MATCHER() {
            return VERIFY_MATCHER;
        }

        @NotNull
        public final FunMatcherImpl getHOSTNAME_VERIFIER_MATCHER() {
            return HOSTNAME_VERIFIER_MATCHER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

