/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.visiting.KotlinFileVisitorKt;

@Rule(key="S6313")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0013\u0010\f\u001a\u00020\u000b*\u00020\u0004H\u0002\u00a2\u0006\u0004\b\f\u0010\rR\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010"}, d2={"Lorg/sonarsource/kotlin/checks/ViewModelSuspendingFunctionsCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "function", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "kotlinFileContext", "", "visitNamedFunction", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "", "extendsViewModel", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;)Z", "Lorg/jetbrains/kotlin/name/ClassId;", "viewModelClassId", "Lorg/jetbrains/kotlin/name/ClassId;"})
public final class ViewModelSuspendingFunctionsCheck
extends AbstractCheck {
    @NotNull
    private final ClassId viewModelClassId = ClassId.Companion.fromString$default(ClassId.Companion, "androidx/lifecycle/ViewModel", false, 2, null);

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2, @NotNull KotlinFileContext kotlinFileContext) {
        block1: {
            Intrinsics.checkNotNullParameter(function2, "function");
            Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
            PsiElement psiElement = ApiExtensionsKt.suspendModifier(function2);
            if (psiElement == null) break block1;
            PsiElement it = psiElement;
            boolean bl = false;
            if (!KtPsiUtilKt.isPrivate(function2) && this.extendsViewModel(function2)) {
                AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, it, "Classes extending \"ViewModel\" should not expose suspending functions.", null, null, 12, null);
            }
        }
    }

    private final boolean extendsViewModel(KtNamedFunction $this$extendsViewModel) {
        boolean bl;
        block4: {
            boolean $i$f$withKaSession = false;
            KaSession kaSession = KotlinFileVisitorKt.getKaSession();
            Intrinsics.checkNotNull(kaSession);
            KaSession $this$extendsViewModel_u24lambda_u242 = kaSession;
            boolean bl2 = false;
            KaSymbol containingSymbol = $this$extendsViewModel_u24lambda_u242.getContainingSymbol($this$extendsViewModel_u24lambda_u242.getSymbol($this$extendsViewModel));
            if (!(containingSymbol instanceof KaClassSymbol)) {
                return false;
            }
            Iterable $this$any$iv = ((KaClassSymbol)containingSymbol).getSuperTypes();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KaType it = (KaType)element$iv;
                    boolean bl3 = false;
                    if (!$this$extendsViewModel_u24lambda_u242.isClassType(it, this.viewModelClassId)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }
}

