/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.symbols.KaEnumEntrySymbol;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.checks.FunMatcherBuilderContext;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.KotlinTextRanges;
import org.sonarsource.kotlin.api.reporting.SecondaryLocation;
import org.sonarsource.kotlin.api.visiting.KotlinFileVisitorKt;

@Rule(key="S4423")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000b\u0010\nJ\u001f\u0010\f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\f\u0010\nJ%\u0010\u0010\u001a\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0013\u001a\u0004\u0018\u00010\u0012*\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u00158\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u00158\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0017R\u0014\u0010\u001a\u001a\u00020\u00198\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u00198\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001b"}, d2={"Lorg/sonarsource/kotlin/checks/WeakSSLContextCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "node", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "kotlinFileContext", "", "visitCallExpression", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "handleSSL", "handleOkHttp", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "unsecureVersions", "reportUnsecureSSLContext", "(Ljava/util/List;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "", "value", "(Lorg/jetbrains/kotlin/psi/KtExpression;)Ljava/lang/String;", "", "WEAK_FOR_OK_HTTP", "Ljava/util/Set;", "WEAK_FOR_SSL", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "OKHTTP_MATCHER", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "SSL_CONTEXT_MATCHER"})
public final class WeakSSLContextCheck
extends AbstractCheck {
    @NotNull
    private final Set<String> WEAK_FOR_OK_HTTP;
    @NotNull
    private final Set<String> WEAK_FOR_SSL;
    @NotNull
    private final FunMatcherImpl OKHTTP_MATCHER;
    @NotNull
    private final FunMatcherImpl SSL_CONTEXT_MATCHER;

    public WeakSSLContextCheck() {
        String[] stringArray = new String[]{"TLSv1", "TLSv1.1", "TLS_1_0", "TLS_1_1", "okhttp3.TlsVersion.TLS_1_0", "okhttp3.TlsVersion.TLS_1_1"};
        this.WEAK_FOR_OK_HTTP = SetsKt.setOf(stringArray);
        stringArray = new String[]{"SSL", "TLS", "DTLS", "SSLv2", "SSLv3", "TLSv1", "TLSv1.1", "DTLSv1.0"};
        this.WEAK_FOR_SSL = SetsKt.setOf(stringArray);
        this.OKHTTP_MATCHER = FunMatcherKt.FunMatcher$default(null, null, null, null, false, null, null, null, null, null, WeakSSLContextCheck::OKHTTP_MATCHER$lambda$0, 1023, null);
        this.SSL_CONTEXT_MATCHER = FunMatcherKt.FunMatcher$default(null, null, null, null, false, null, null, null, null, null, WeakSSLContextCheck::SSL_CONTEXT_MATCHER$lambda$1, 1023, null);
    }

    @Override
    public void visitCallExpression(@NotNull KtCallExpression node, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        if (this.SSL_CONTEXT_MATCHER.matches(node)) {
            this.handleSSL(node, kotlinFileContext);
        } else if (this.OKHTTP_MATCHER.matches(node)) {
            this.handleOkHttp(node, kotlinFileContext);
        }
    }

    private final void handleSSL(KtCallExpression node, KotlinFileContext kotlinFileContext) {
        block1: {
            KtExpression ktExpression;
            List<KtValueArgument> list = node.getValueArguments();
            Intrinsics.checkNotNullExpressionValue(list, "getValueArguments(...)");
            KtValueArgument ktValueArgument = CollectionsKt.firstOrNull(list);
            if (ktValueArgument == null || (ktExpression = ktValueArgument.getArgumentExpression()) == null) break block1;
            KtExpression it = ktExpression;
            boolean bl = false;
            if (CollectionsKt.contains((Iterable)this.WEAK_FOR_SSL, this.value(it))) {
                this.reportUnsecureSSLContext(CollectionsKt.listOf(it), kotlinFileContext);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleOkHttp(KtCallExpression node, KotlinFileContext kotlinFileContext) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        List<KtValueArgument> list = node.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(list, "getValueArguments(...)");
        Iterable iterable = list;
        boolean $i$f$mapNotNull = false;
        void var6_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KtExpression it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            KtValueArgument it = (KtValueArgument)element$iv$iv;
            boolean bl2 = false;
            if (it.getArgumentExpression() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtExpression it = (KtExpression)element$iv$iv;
            boolean bl = false;
            if (!CollectionsKt.contains((Iterable)this.WEAK_FOR_OK_HTTP, this.value(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unsecureVersions = (List)destination$iv$iv;
        this.reportUnsecureSSLContext(unsecureVersions, kotlinFileContext);
    }

    /*
     * WARNING - void declaration
     */
    private final void reportUnsecureSSLContext(List<? extends KtExpression> unsecureVersions, KotlinFileContext kotlinFileContext) {
        if (!((Collection)unsecureVersions).isEmpty()) {
            Collection<SecondaryLocation> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List<KtExpression> secondaries = CollectionsKt.minus((Iterable)unsecureVersions, unsecureVersions.get(0));
            Iterable iterable = secondaries;
            String string2 = "Change this code to use a stronger protocol.";
            PsiElement psiElement = unsecureVersions.get(0);
            KotlinFileContext kotlinFileContext2 = kotlinFileContext;
            AbstractCheck abstractCheck = this;
            boolean $i$f$map = false;
            void var6_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KtExpression ktExpression = (KtExpression)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new SecondaryLocation(KotlinTextRanges.INSTANCE.textRange(kotlinFileContext, (PsiElement)it), "Other weak protocol."));
            }
            collection = (List)destination$iv$iv;
            AbstractCheck.reportIssue$default(abstractCheck, kotlinFileContext2, psiElement, string2, (List)collection, null, 8, null);
        }
    }

    private final String value(KtExpression $this$value) {
        String string2;
        boolean $i$f$withKaSession = false;
        KaSession kaSession = KotlinFileVisitorKt.getKaSession();
        Intrinsics.checkNotNull(kaSession);
        KaSession $this$value_u24lambda_u246 = kaSession;
        boolean bl = false;
        KtExpression ktExpression = $this$value;
        if (ktExpression instanceof KtStringTemplateExpression) {
            string2 = this.asConstant((KtStringTemplateExpression)$this$value);
        } else if (ktExpression instanceof KtNameReferenceExpression) {
            string2 = ApiExtensionsKt.predictRuntimeStringValue($this$value);
        } else if (ktExpression instanceof KtDotQualifiedExpression) {
            FqName fqName2;
            KaEnumEntrySymbol kaEnumEntrySymbol;
            Object object = ((KtDotQualifiedExpression)$this$value).getSelectorExpression();
            Object object2 = object != null && (object = ReferenceUtilsKt.getMainReference((KtElement)object)) != null ? $this$value_u24lambda_u246.resolveToSymbol((KtReference)object) : null;
            KaEnumEntrySymbol kaEnumEntrySymbol2 = kaEnumEntrySymbol = object2 instanceof KaEnumEntrySymbol ? (KaEnumEntrySymbol)object2 : null;
            string2 = kaEnumEntrySymbol != null && (object2 = kaEnumEntrySymbol.getCallableId()) != null && (fqName2 = ((CallableId)object2).asSingleFqName()) != null ? fqName2.asString() : null;
        } else {
            string2 = null;
        }
        return string2;
    }

    private static final Unit OKHTTP_MATCHER$lambda$0(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        $this$FunMatcher.setQualifier("okhttp3.ConnectionSpec.Builder");
        $this$FunMatcher.setName("tlsVersions");
        return Unit.INSTANCE;
    }

    private static final Unit SSL_CONTEXT_MATCHER$lambda$1(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        $this$FunMatcher.setQualifier("javax.net.ssl.SSLContext");
        $this$FunMatcher.setName("getInstance");
        return Unit.INSTANCE;
    }
}

