/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.gradle.checks;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtScriptInitializer;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.KotlinTextRanges;
import org.sonarsource.kotlin.api.reporting.SecondaryLocation;
import org.sonarsource.kotlin.gradle.checks.AndroidReleaseBuildUtilsKt;
import org.sonarsource.kotlin.gradle.checks.CalleeAndLambda;

@Rule(key="S7204")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\n"}, d2={"Lorg/sonarsource/kotlin/gradle/checks/AndroidReleaseBuildObfuscationCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtScriptInitializer;", "initializer", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "data", "", "visitScriptInitializer", "(Lorg/jetbrains/kotlin/psi/KtScriptInitializer;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V"})
public final class AndroidReleaseBuildObfuscationCheck
extends AbstractCheck {
    /*
     * WARNING - void declaration
     */
    @Override
    public void visitScriptInitializer(@NotNull KtScriptInitializer initializer, @NotNull KotlinFileContext data2) {
        Intrinsics.checkNotNullParameter(initializer, "initializer");
        Intrinsics.checkNotNullParameter(data2, "data");
        if (AndroidReleaseBuildUtilsKt.isSettingGradleKts(data2.getKtFile())) {
            return;
        }
        CalleeAndLambda calleeAndLambda = AndroidReleaseBuildUtilsKt.getChildCallWithLambdaOrNull(initializer, "android");
        if (calleeAndLambda == null) {
            return;
        }
        CalleeAndLambda calleeAndLambda2 = calleeAndLambda;
        KtExpression androidCallee = calleeAndLambda2.component1();
        KtFunctionLiteral androidLambda = calleeAndLambda2.component2();
        if (AndroidReleaseBuildUtilsKt.getApplicationId(androidLambda) == null) {
            return;
        }
        CalleeAndLambda buildTypes = AndroidReleaseBuildUtilsKt.getChildCallWithLambdaOrNull(androidLambda, "buildTypes");
        if (buildTypes == null) {
            AbstractCheck.reportIssue$default((AbstractCheck)this, data2, (PsiElement)androidCallee, "Make sure that obfuscation is enabled in the release build configuration.", null, null, 12, null);
            return;
        }
        CalleeAndLambda calleeAndLambda3 = AndroidReleaseBuildUtilsKt.getChildCallWithLambdaOrNull(buildTypes.getLambda(), "release");
        if (calleeAndLambda3 == null && (calleeAndLambda3 = AndroidReleaseBuildUtilsKt.getGetByNameCallWithLambdaOrNull(androidLambda)) == null) {
            return;
        }
        CalleeAndLambda calleeAndLambda4 = calleeAndLambda3;
        KtExpression releaseCallee = calleeAndLambda4.component1();
        KtFunctionLiteral releaseLambda = calleeAndLambda4.component2();
        KtBinaryExpression isDebuggableAssignment = AndroidReleaseBuildUtilsKt.getPropertyAssignmentOrNull(releaseLambda, "isDebuggable");
        KtBinaryExpression isMinifiedEnabledAssignment = AndroidReleaseBuildUtilsKt.getPropertyAssignmentOrNull(releaseLambda, "isMinifyEnabled");
        if (isMinifiedEnabledAssignment == null) {
            AbstractCheck.reportIssue$default((AbstractCheck)this, data2, (PsiElement)releaseCallee, "Make sure that obfuscation is enabled in the release build configuration.", null, null, 12, null);
        } else {
            KtExpression ktExpression = isMinifiedEnabledAssignment.getRight();
            if (ktExpression != null ? Intrinsics.areEqual(ApiExtensionsKt.predictRuntimeBooleanValue(ktExpression), false) : false) {
                AbstractCheck.reportIssue$default((AbstractCheck)this, data2, (PsiElement)isMinifiedEnabledAssignment, "Make sure that obfuscation is enabled in the release build configuration.", null, null, 12, null);
            } else {
                KtExpression ktExpression2 = isDebuggableAssignment;
                if (ktExpression2 != null && (ktExpression2 = ktExpression2.getRight()) != null ? Intrinsics.areEqual(ApiExtensionsKt.predictRuntimeBooleanValue(ktExpression2), true) : false) {
                    Collection<SecondaryLocation> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = CollectionsKt.listOf(isDebuggableAssignment);
                    String string2 = "Enabling debugging disables obfuscation for this release build. Make sure this is safe here.";
                    PsiElement psiElement = releaseCallee;
                    KotlinFileContext kotlinFileContext = data2;
                    AbstractCheck abstractCheck = this;
                    boolean $i$f$map = false;
                    void var14_18 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(new SecondaryLocation(KotlinTextRanges.INSTANCE.textRange(data2, (PsiElement)it), ""));
                    }
                    collection = (List)destination$iv$iv;
                    AbstractCheck.reportIssue$default(abstractCheck, kotlinFileContext, psiElement, string2, (List)collection, null, 8, null);
                } else if (AndroidReleaseBuildUtilsKt.getChildCallOrNull(releaseLambda, "proguardFiles") == null) {
                    AbstractCheck.reportIssue$default((AbstractCheck)this, data2, (PsiElement)releaseCallee, "Make sure that obfuscation is enabled in the release build configuration.", null, null, 12, null);
                }
            }
        }
    }
}

