/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.gradle.checks;

import com.intellij.psi.impl.ElementBase;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.resolve.calls.util.PsiUtilsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0004\u001a\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0001\u001a\u00020\u0000H\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u0019\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0001\u001a\u00020\u0000H\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007\"\u0014\u0010\b\u001a\u00020\u00028\u0000X\u0081T\u00a2\u0006\u0006\n\u0004\b\b\u0010\t\" \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\n8\u0001X\u0081\u0004\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e"}, d2={"Lorg/jetbrains/kotlin/psi/KtCallExpression;", "expression", "", "getFunctionName", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "getLambdaBlock", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;)Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "REF_NAME_DEPENDENCIES", "Ljava/lang/String;", "", "REF_NAME_DEPENDENCY_HANDLER_SCOPE_EXTENSIONS", "Ljava/util/Set;", "getREF_NAME_DEPENDENCY_HANDLER_SCOPE_EXTENSIONS", "()Ljava/util/Set;"})
public final class DependencyChecksKt {
    @NotNull
    public static final String REF_NAME_DEPENDENCIES = "dependencies";
    @NotNull
    private static final Set<String> REF_NAME_DEPENDENCY_HANDLER_SCOPE_EXTENSIONS;

    @NotNull
    public static final Set<String> getREF_NAME_DEPENDENCY_HANDLER_SCOPE_EXTENSIONS() {
        return REF_NAME_DEPENDENCY_HANDLER_SCOPE_EXTENSIONS;
    }

    @Nullable
    public static final String getFunctionName(@NotNull KtCallExpression expression) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        KtExpression ktExpression = PsiUtilsKt.getCalleeExpressionIfAny(expression);
        KtNameReferenceExpression ktNameReferenceExpression = ktExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression : null;
        return ktNameReferenceExpression != null ? ktNameReferenceExpression.getReferencedName() : null;
    }

    @Nullable
    public static final KtBlockExpression getLambdaBlock(@NotNull KtCallExpression expression) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        List<KtValueArgument> list = expression.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(list, "getValueArguments(...)");
        KtValueArgument ktValueArgument = CollectionsKt.lastOrNull(list);
        KtLambdaArgument lambdaArg = ktValueArgument instanceof KtLambdaArgument ? (KtLambdaArgument)ktValueArgument : null;
        ElementBase elementBase = lambdaArg;
        return elementBase != null && (elementBase = ((KtLambdaArgument)elementBase).getLambdaExpression()) != null ? ((KtLambdaExpression)elementBase).getBodyExpression() : null;
    }

    static {
        String[] stringArray = new String[]{"annotationProcessor", "compile", "compileClasspath", "compileOnly", "implementation", "runtime", "runtimeClasspath", "runtimeOnly", "testAnnotationProcessor", "testCompile", "testCompileClasspath", "testCompileOnly", "testImplementation", "testRuntime", "testRuntimeClasspath", "testRuntimeOnly"};
        REF_NAME_DEPENDENCY_HANDLER_SCOPE_EXTENSIONS = SetsKt.setOf(stringArray);
    }
}

