/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.gradle.checks;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.calls.util.PsiUtilsKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.KotlinTextRanges;
import org.sonarsource.kotlin.api.reporting.SecondaryLocation;
import org.sonarsource.kotlin.gradle.checks.DependencyChecksKt;

@Rule(key="S6629")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000b\u0010\n"}, d2={"Lorg/sonarsource/kotlin/gradle/checks/DependencyGroupedCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "expression", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "kotlinFileContext", "", "visitCallExpression", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "checkDependencyHandlerScopeLambda", "DependencyHandlerScopeLambdaCheck"})
public final class DependencyGroupedCheck
extends AbstractCheck {
    @Override
    public void visitCallExpression(@NotNull KtCallExpression expression, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        if (!Intrinsics.areEqual(DependencyChecksKt.getFunctionName(expression), "dependencies")) {
            return;
        }
        this.checkDependencyHandlerScopeLambda(expression, kotlinFileContext);
    }

    private final void checkDependencyHandlerScopeLambda(KtCallExpression expression, KotlinFileContext kotlinFileContext) {
        DependencyHandlerScopeLambdaCheck visitor2 = new DependencyHandlerScopeLambdaCheck(kotlinFileContext);
        KtBlockExpression ktBlockExpression = DependencyChecksKt.getLambdaBlock(expression);
        if (ktBlockExpression != null) {
            ktBlockExpression.acceptChildren(visitor2);
        }
        if (!((Collection)visitor2.getSecondaryLocations()).isEmpty()) {
            AbstractCheck abstractCheck = this;
            KtExpression ktExpression = PsiUtilsKt.getCalleeExpressionIfAny(expression);
            Intrinsics.checkNotNull(ktExpression);
            AbstractCheck.reportIssue$default(abstractCheck, kotlinFileContext, (PsiElement)ktExpression, "Group dependencies by their destination.", visitor2.getSecondaryLocations(), null, 8, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\r\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u000fR\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00108\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u00138\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R \u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b"}, d2={"Lorg/sonarsource/kotlin/gradle/checks/DependencyGroupedCheck$DependencyHandlerScopeLambdaCheck;", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "kotlinFileContext", "<init>", "(Lorg/sonarsource/kotlin/gradle/checks/DependencyGroupedCheck;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "expression", "", "visitCallExpression", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;)V", "Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;", "functionReference", "checkFunctionReferenceOrder", "(Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;)V", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "", "lastNameInOrder", "Ljava/lang/String;", "", "visitedNames", "Ljava/util/Set;", "", "Lorg/sonarsource/kotlin/api/reporting/SecondaryLocation;", "secondaryLocations", "Ljava/util/List;", "getSecondaryLocations", "()Ljava/util/List;"})
    private final class DependencyHandlerScopeLambdaCheck
    extends KtVisitorVoid {
        @NotNull
        private final KotlinFileContext kotlinFileContext;
        @Nullable
        private String lastNameInOrder;
        @NotNull
        private final Set<String> visitedNames;
        @NotNull
        private final List<SecondaryLocation> secondaryLocations;

        public DependencyHandlerScopeLambdaCheck(KotlinFileContext kotlinFileContext) {
            Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
            this.kotlinFileContext = kotlinFileContext;
            this.visitedNames = new LinkedHashSet();
            this.secondaryLocations = new ArrayList();
        }

        @NotNull
        public final List<SecondaryLocation> getSecondaryLocations() {
            return this.secondaryLocations;
        }

        @Override
        public void visitCallExpression(@NotNull KtCallExpression expression) {
            Intrinsics.checkNotNullParameter(expression, "expression");
            KtExpression ktExpression = PsiUtilsKt.getCalleeExpressionIfAny(expression);
            KtNameReferenceExpression ktNameReferenceExpression = ktExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression : null;
            if (ktNameReferenceExpression == null) {
                return;
            }
            KtNameReferenceExpression functionReference = ktNameReferenceExpression;
            String functionName = functionReference.getReferencedName();
            if (Intrinsics.areEqual(functionName, "constraints")) {
                DependencyGroupedCheck.this.checkDependencyHandlerScopeLambda(expression, this.kotlinFileContext);
            } else if (DependencyChecksKt.getREF_NAME_DEPENDENCY_HANDLER_SCOPE_EXTENSIONS().contains(functionName)) {
                this.checkFunctionReferenceOrder(functionReference);
            }
        }

        public final void checkFunctionReferenceOrder(@NotNull KtNameReferenceExpression functionReference) {
            Intrinsics.checkNotNullParameter(functionReference, "functionReference");
            String functionName = functionReference.getReferencedName();
            if (this.lastNameInOrder != null && !Intrinsics.areEqual(functionName, this.lastNameInOrder) && this.visitedNames.contains(functionName)) {
                this.secondaryLocations.add(new SecondaryLocation(KotlinTextRanges.INSTANCE.textRange(this.kotlinFileContext, functionReference), null, 2, null));
            } else {
                this.lastNameInOrder = functionName;
            }
            this.visitedNames.add(functionName);
        }
    }
}

