/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.gradle.checks;

import com.intellij.openapi.util.TextRange;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.KotlinTextRanges;
import org.sonarsource.kotlin.gradle.checks.DependencyChecksKt;
import org.sonarsource.kotlin.gradle.checks.DependencyVersionHardcodedCheckKt;

@Rule(key="S6624")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000b\u0010\nJ'\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010"}, d2={"Lorg/sonarsource/kotlin/gradle/checks/DependencyVersionHardcodedCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "expression", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "kotlinFileContext", "", "visitCallExpression", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "checkDependencyHandlerScopeLambda", "", "textStartOffset", "textEndOffset", "reportIssue", "(Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;II)V", "DependencyHandlerScopeLambdaCheck"})
public final class DependencyVersionHardcodedCheck
extends AbstractCheck {
    @Override
    public void visitCallExpression(@NotNull KtCallExpression expression, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        if (!Intrinsics.areEqual(DependencyChecksKt.getFunctionName(expression), "dependencies")) {
            return;
        }
        this.checkDependencyHandlerScopeLambda(expression, kotlinFileContext);
    }

    private final void checkDependencyHandlerScopeLambda(KtCallExpression expression, KotlinFileContext kotlinFileContext) {
        block0: {
            KtBlockExpression ktBlockExpression = DependencyChecksKt.getLambdaBlock(expression);
            if (ktBlockExpression == null) break block0;
            ktBlockExpression.acceptChildren(new DependencyHandlerScopeLambdaCheck(kotlinFileContext));
        }
    }

    private final void reportIssue(KotlinFileContext kotlinFileContext, int textStartOffset, int textEndOffset) {
        AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, KotlinTextRanges.INSTANCE.textRange(kotlinFileContext, textStartOffset, textEndOffset), "Do not hardcode version numbers.", null, null, 12, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u000b"}, d2={"Lorg/sonarsource/kotlin/gradle/checks/DependencyVersionHardcodedCheck$DependencyHandlerScopeLambdaCheck;", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "kotlinFileContext", "<init>", "(Lorg/sonarsource/kotlin/gradle/checks/DependencyVersionHardcodedCheck;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "expression", "", "visitCallExpression", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;)V", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;"})
    private final class DependencyHandlerScopeLambdaCheck
    extends KtVisitorVoid {
        @NotNull
        private final KotlinFileContext kotlinFileContext;

        public DependencyHandlerScopeLambdaCheck(KotlinFileContext kotlinFileContext) {
            Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
            this.kotlinFileContext = kotlinFileContext;
        }

        @Override
        public void visitCallExpression(@NotNull KtCallExpression expression) {
            Intrinsics.checkNotNullParameter(expression, "expression");
            String string2 = DependencyChecksKt.getFunctionName(expression);
            if (string2 == null) {
                return;
            }
            String functionName = string2;
            if (!DependencyChecksKt.getREF_NAME_DEPENDENCY_HANDLER_SCOPE_EXTENSIONS().contains(functionName)) {
                return;
            }
            if (expression.getValueArguments().size() == 1) {
                List<KtValueArgument> list = expression.getValueArguments();
                Intrinsics.checkNotNullExpressionValue(list, "getValueArguments(...)");
                Object object = CollectionsKt.first(list).getArgumentExpression();
                KtStringTemplateExpression ktStringTemplateExpression = object instanceof KtStringTemplateExpression ? (KtStringTemplateExpression)object : null;
                if (ktStringTemplateExpression == null) {
                    return;
                }
                KtStringTemplateExpression stringArgument = ktStringTemplateExpression;
                KtLiteralStringTemplateEntry ktLiteralStringTemplateEntry = DependencyVersionHardcodedCheckKt.access$simpleStringOrNull(stringArgument);
                if (ktLiteralStringTemplateEntry == null) {
                    return;
                }
                KtLiteralStringTemplateEntry simpleString = ktLiteralStringTemplateEntry;
                String string3 = simpleString.getText();
                Intrinsics.checkNotNullExpressionValue(string3, "getText(...)");
                object = string3;
                if (DependencyVersionHardcodedCheckKt.access$getPATTERN_DEPENDENCY_WITH_VERSION$p().matches((CharSequence)object)) {
                    object = stringArgument.getTextRange();
                    DependencyVersionHardcodedCheck dependencyVersionHardcodedCheck = DependencyVersionHardcodedCheck.this;
                    Object $this$visitCallExpression_u24lambda_u240 = object;
                    boolean bl = false;
                    int n = ((TextRange)$this$visitCallExpression_u24lambda_u240).getStartOffset();
                    String string4 = simpleString.getText();
                    Intrinsics.checkNotNullExpressionValue(string4, "getText(...)");
                    dependencyVersionHardcodedCheck.reportIssue(this.kotlinFileContext, n + StringsKt.lastIndexOf$default((CharSequence)string4, ':', 0, false, 6, null) + 2, ((TextRange)$this$visitCallExpression_u24lambda_u240).getEndOffset() - 1);
                }
            } else {
                KtStringTemplateExpression stringArgument;
                List<KtValueArgument> list = expression.getValueArguments();
                Intrinsics.checkNotNullExpressionValue(list, "getValueArguments(...)");
                Object object = DependencyVersionHardcodedCheckKt.access$findVersionArgumentOrNull(list);
                Object object2 = object != null ? ((KtValueArgument)object).getArgumentExpression() : null;
                KtStringTemplateExpression ktStringTemplateExpression = stringArgument = object2 instanceof KtStringTemplateExpression ? (KtStringTemplateExpression)object2 : null;
                if ((ktStringTemplateExpression != null ? DependencyVersionHardcodedCheckKt.access$simpleStringOrNull(ktStringTemplateExpression) : null) != null) {
                    object2 = stringArgument.getTextRange();
                    object = DependencyVersionHardcodedCheck.this;
                    Object $this$visitCallExpression_u24lambda_u241 = object2;
                    boolean bl = false;
                    ((DependencyVersionHardcodedCheck)object).reportIssue(this.kotlinFileContext, ((TextRange)$this$visitCallExpression_u24lambda_u241).getStartOffset() + 1, ((TextRange)$this$visitCallExpression_u24lambda_u241).getEndOffset() - 1);
                }
            }
        }
    }
}

