/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.gradle.checks;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.calls.util.PsiUtilsKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.Message;
import org.sonarsource.kotlin.api.reporting.MessageKt;
import org.sonarsource.kotlin.gradle.checks.RootProjectNamePresentCheckKt;

@Rule(key="S6625")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\n"}, d2={"Lorg/sonarsource/kotlin/gradle/checks/RootProjectNamePresentCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtFile;", "file", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "kotlinFileContext", "", "visitKtFile", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "ScanRootProjectNameAssign"})
public final class RootProjectNamePresentCheck
extends AbstractCheck {
    @Override
    public void visitKtFile(@NotNull KtFile file2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        String string2 = file2.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
        if (!StringsKt.endsWith$default(string2, "settings.gradle.kts", false, 2, null)) {
            return;
        }
        ScanRootProjectNameAssign visitor2 = new ScanRootProjectNameAssign();
        file2.acceptChildren(visitor2);
        if (!visitor2.isRootProjectNameAssigned()) {
            AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, null, MessageKt.message(RootProjectNamePresentCheck::visitKtFile$lambda$0), null, null, 12, null);
        }
    }

    private static final Unit visitKtFile$lambda$0(Message $this$message) {
        Intrinsics.checkNotNullParameter($this$message, "$this$message");
        $this$message.unaryPlus("Assign ");
        $this$message.code("rootProject.name");
        $this$message.unaryPlus(" in ");
        $this$message.code("settings.gradle.kts");
        $this$message.unaryPlus(".");
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bR\"\u0010\r\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u001a\u0004\b\r\u0010\u000f\"\u0004\b\u0010\u0010\u0011"}, d2={"Lorg/sonarsource/kotlin/gradle/checks/RootProjectNamePresentCheck$ScanRootProjectNameAssign;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "expression", "", "visitBinaryExpression", "(Lorg/jetbrains/kotlin/psi/KtBinaryExpression;)V", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitCallExpression", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;)V", "", "isRootProjectNameAssigned", "Z", "()Z", "setRootProjectNameAssigned", "(Z)V"})
    private static final class ScanRootProjectNameAssign
    extends KtTreeVisitorVoid {
        private boolean isRootProjectNameAssigned;

        public final boolean isRootProjectNameAssigned() {
            return this.isRootProjectNameAssigned;
        }

        public final void setRootProjectNameAssigned(boolean bl) {
            this.isRootProjectNameAssigned = bl;
        }

        @Override
        public void visitBinaryExpression(@NotNull KtBinaryExpression expression) {
            Intrinsics.checkNotNullParameter(expression, "expression");
            if (!Intrinsics.areEqual(expression.getOperationToken(), KtTokens.EQ)) {
                return;
            }
            KtExpression ktExpression = expression.getLeft();
            KtDotQualifiedExpression ktDotQualifiedExpression = ktExpression instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)ktExpression : null;
            if (ktDotQualifiedExpression == null) {
                return;
            }
            KtDotQualifiedExpression qualifier = ktDotQualifiedExpression;
            KtExpression ktExpression2 = qualifier.getReceiverExpression();
            KtNameReferenceExpression ktNameReferenceExpression = ktExpression2 instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression2 : null;
            if (ktNameReferenceExpression == null) {
                return;
            }
            KtNameReferenceExpression receiver = ktNameReferenceExpression;
            KtExpression ktExpression3 = qualifier.getSelectorExpression();
            KtNameReferenceExpression ktNameReferenceExpression2 = ktExpression3 instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression3 : null;
            if (ktNameReferenceExpression2 == null) {
                return;
            }
            KtNameReferenceExpression selector = ktNameReferenceExpression2;
            if (Intrinsics.areEqual(receiver.getReferencedName(), "rootProject") && Intrinsics.areEqual(selector.getReferencedName(), "name")) {
                this.isRootProjectNameAssigned = true;
            }
        }

        @Override
        public void visitCallExpression(@NotNull KtCallExpression expression) {
            Intrinsics.checkNotNullParameter(expression, "expression");
            PsiElement psiElement = expression.getParent();
            KtDotQualifiedExpression ktDotQualifiedExpression = psiElement instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)psiElement : null;
            if (ktDotQualifiedExpression == null) {
                return;
            }
            KtDotQualifiedExpression qualifier = ktDotQualifiedExpression;
            KtExpression ktExpression = PsiUtilsKt.getCalleeExpressionIfAny(expression);
            if (Intrinsics.areEqual(ktExpression != null ? RootProjectNamePresentCheckKt.access$getReferencedName(ktExpression) : null, "setName") && Intrinsics.areEqual(RootProjectNamePresentCheckKt.access$getReferencedName(qualifier.getReceiverExpression()), "rootProject")) {
                this.isRootProjectNameAssigned = true;
            }
        }
    }
}

