/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.metrics;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenEntry;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u001c8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u001d"}, d2={"Lorg/sonarsource/kotlin/metrics/CyclomaticComplexityVisitor;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "<init>", "()V", "", "Lcom/intellij/psi/PsiElement;", "complexityTrees", "()Ljava/util/List;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "function", "", "visitNamedFunction", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;)V", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "expression", "visitIfExpression", "(Lorg/jetbrains/kotlin/psi/KtIfExpression;)V", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "loopExpression", "visitLoopExpression", "(Lorg/jetbrains/kotlin/psi/KtLoopExpression;)V", "Lorg/jetbrains/kotlin/psi/KtWhenEntry;", "whenEntry", "visitWhenEntry", "(Lorg/jetbrains/kotlin/psi/KtWhenEntry;)V", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitBinaryExpression", "(Lorg/jetbrains/kotlin/psi/KtBinaryExpression;)V", "", "Ljava/util/List;"})
public final class CyclomaticComplexityVisitor
extends KtTreeVisitorVoid {
    @NotNull
    private final List<PsiElement> complexityTrees = new ArrayList();

    @NotNull
    public final List<PsiElement> complexityTrees() {
        return CollectionsKt.toList((Iterable)this.complexityTrees);
    }

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        if (function2.hasBody() && function2.getName() != null) {
            this.complexityTrees.add(function2);
        }
        super.visitNamedFunction(function2);
    }

    @Override
    public void visitIfExpression(@NotNull KtIfExpression expression) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        PsiElement psiElement = expression.getIfKeyword();
        Intrinsics.checkNotNullExpressionValue(psiElement, "getIfKeyword(...)");
        this.complexityTrees.add(psiElement);
        super.visitIfExpression(expression);
    }

    @Override
    public void visitLoopExpression(@NotNull KtLoopExpression loopExpression) {
        Intrinsics.checkNotNullParameter(loopExpression, "loopExpression");
        this.complexityTrees.add(loopExpression);
        super.visitLoopExpression(loopExpression);
    }

    @Override
    public void visitWhenEntry(@NotNull KtWhenEntry whenEntry) {
        Intrinsics.checkNotNullParameter(whenEntry, "whenEntry");
        this.complexityTrees.add(whenEntry);
        super.visitWhenEntry(whenEntry);
    }

    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression expression) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        if (Intrinsics.areEqual(expression.getOperationToken(), KtTokens.ANDAND) || Intrinsics.areEqual(expression.getOperationToken(), KtTokens.OROR)) {
            this.complexityTrees.add(expression);
        }
        super.visitBinaryExpression(expression);
    }
}

