/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.metrics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.sonarsource.kotlin.metrics.StatementsVisitorKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0013\u0010\u0012\u001a\u00020\u0006*\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u0017\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eR\"\u0010 \u001a\u00020\u001f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%"}, d2={"Lorg/sonarsource/kotlin/metrics/StatementsVisitor;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "expression", "", "visitBlockExpression", "(Lorg/jetbrains/kotlin/psi/KtBlockExpression;)V", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "function", "visitNamedFunction", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;)V", "Lorg/jetbrains/kotlin/psi/KtProperty;", "property", "visitProperty", "(Lorg/jetbrains/kotlin/psi/KtProperty;)V", "Lorg/jetbrains/kotlin/psi/KtExpression;", "checkStatements", "(Lorg/jetbrains/kotlin/psi/KtExpression;)V", "processExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "processIfExpression", "(Lorg/jetbrains/kotlin/psi/KtIfExpression;)V", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "processWhenExpression", "(Lorg/jetbrains/kotlin/psi/KtWhenExpression;)V", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "loopExpression", "processLoopExpression", "(Lorg/jetbrains/kotlin/psi/KtLoopExpression;)V", "", "statements", "I", "getStatements", "()I", "setStatements", "(I)V"})
public final class StatementsVisitor
extends KtTreeVisitorVoid {
    private int statements;

    public final int getStatements() {
        return this.statements;
    }

    public final void setStatements(int n) {
        this.statements = n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitBlockExpression(@NotNull KtBlockExpression expression) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(expression, "expression");
        List<KtExpression> list = expression.getStatements();
        Intrinsics.checkNotNullExpressionValue(list, "getStatements(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtExpression it = (KtExpression)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            if (!(!StatementsVisitorKt.access$isDeclaration(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtExpression it = (KtExpression)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            this.checkStatements(it);
        }
        super.visitBlockExpression(expression);
    }

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        KtExpression ktExpression = function2.getBodyExpression();
        if (ktExpression != null) {
            this.checkStatements(ktExpression);
        }
        super.visitNamedFunction(function2);
    }

    @Override
    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkNotNullParameter(property, "property");
        if (property.isLocal()) {
            return;
        }
        KtExpression ktExpression = property.getInitializer();
        if (ktExpression != null) {
            this.checkStatements(ktExpression);
        }
        super.visitProperty(property);
    }

    private final void checkStatements(KtExpression $this$checkStatements) {
        KtExpression it = $this$checkStatements;
        boolean bl = false;
        if (!(it instanceof KtBlockExpression)) {
            this.processExpression(it);
            int n = this.statements;
            this.statements = n + 1;
        }
    }

    private final void processExpression(KtExpression expression) {
        KtExpression ktExpression = expression;
        if (ktExpression instanceof KtIfExpression) {
            this.processIfExpression((KtIfExpression)expression);
        } else if (ktExpression instanceof KtWhenExpression) {
            this.processWhenExpression((KtWhenExpression)expression);
        } else if (ktExpression instanceof KtLoopExpression) {
            this.processLoopExpression((KtLoopExpression)expression);
        }
    }

    private final void processIfExpression(KtIfExpression expression) {
        int n;
        if (expression.getThen() != null && !(expression.getThen() instanceof KtBlockExpression)) {
            n = this.statements;
            this.statements = n + 1;
        }
        if (expression.getElse() != null && !(expression.getElse() instanceof KtBlockExpression)) {
            n = this.statements;
            this.statements = n + 1;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processWhenExpression(KtWhenExpression expression) {
        void $this$filterNotTo$iv$iv;
        List<KtWhenEntry> list = expression.getEntries();
        Intrinsics.checkNotNullExpressionValue(list, "getEntries(...)");
        Iterable $this$filterNot$iv = list;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            KtWhenEntry it = (KtWhenEntry)element$iv$iv;
            boolean bl = false;
            if (it.getExpression() instanceof KtBlockExpression) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtWhenEntry it = (KtWhenEntry)element$iv;
            boolean bl = false;
            int n = this.statements;
            this.statements = n + 1;
        }
    }

    private final void processLoopExpression(KtLoopExpression loopExpression) {
        if (!(loopExpression.getBody() instanceof KtBlockExpression)) {
            int n = this.statements;
            this.statements = n + 1;
        }
    }
}

