/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.plugin;

import com.sonarsource.plugins.kotlin.api.KotlinPluginExtensionsProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.sonar.api.SonarProduct;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.cache.ReadCache;
import org.sonar.api.batch.sensor.cache.WriteCache;
import org.sonar.api.batch.sensor.cpd.NewCpdTokens;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonarsource.analyzer.commons.ProgressReport;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.common.KotlinLanguage;
import org.sonarsource.kotlin.api.logging.LoggerExtensionsKt;
import org.sonarsource.kotlin.api.sensors.AbstractKotlinSensor;
import org.sonarsource.kotlin.api.sensors.AbstractKotlinSensorExecuteContext;
import org.sonarsource.kotlin.api.visiting.KotlinFileVisitor;
import org.sonarsource.kotlin.api.visiting.KtChecksVisitor;
import org.sonarsource.kotlin.metrics.IssueSuppressionVisitor;
import org.sonarsource.kotlin.metrics.MetricVisitor;
import org.sonarsource.kotlin.metrics.SyntaxHighlighter;
import org.sonarsource.kotlin.plugin.KotlinCheckListKt;
import org.sonarsource.kotlin.plugin.KotlinProjectSensor;
import org.sonarsource.kotlin.plugin.KotlinSensorKt;
import org.sonarsource.kotlin.plugin.caching.ContentHashCache;
import org.sonarsource.kotlin.plugin.cpd.CPDToken;
import org.sonarsource.kotlin.plugin.cpd.CachingKt;
import org.sonarsource.kotlin.plugin.cpd.CopyPasteDetector;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J4\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0016J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010'\u001a\u00020%2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001a\u0010(\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001b2\b\u0010)\u001a\u0004\u0018\u00010*H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/sonarsource/kotlin/plugin/KotlinSensor;", "Lorg/sonarsource/kotlin/api/sensors/AbstractKotlinSensor;", "checkFactory", "Lorg/sonar/api/batch/rule/CheckFactory;", "fileLinesContextFactory", "Lorg/sonar/api/measures/FileLinesContextFactory;", "noSonarFilter", "Lorg/sonar/api/issue/NoSonarFilter;", "language", "Lorg/sonarsource/kotlin/api/common/KotlinLanguage;", "kotlinProjectSensor", "Lorg/sonarsource/kotlin/plugin/KotlinProjectSensor;", "extensionsProviders", "", "Lcom/sonarsource/plugins/kotlin/api/KotlinPluginExtensionsProvider;", "<init>", "(Lorg/sonar/api/batch/rule/CheckFactory;Lorg/sonar/api/measures/FileLinesContextFactory;Lorg/sonar/api/issue/NoSonarFilter;Lorg/sonarsource/kotlin/api/common/KotlinLanguage;Lorg/sonarsource/kotlin/plugin/KotlinProjectSensor;[Lcom/sonarsource/plugins/kotlin/api/KotlinPluginExtensionsProvider;)V", "describe", "", "descriptor", "Lorg/sonar/api/batch/sensor/SensorDescriptor;", "getExecuteContext", "Lorg/sonarsource/kotlin/api/sensors/AbstractKotlinSensorExecuteContext;", "sensorContext", "Lorg/sonar/api/batch/sensor/SensorContext;", "filesToAnalyze", "", "Lorg/sonar/api/batch/fs/InputFile;", "progressReport", "Lorg/sonarsource/analyzer/commons/ProgressReport;", "filenames", "", "", "visitors", "Lorg/sonarsource/kotlin/api/visiting/KotlinFileVisitor;", "getFilesToAnalyse", "reuseCPDTokens", "", "inputFile", "canSkipUnchangedFiles", "fileHasChanged", "contentHashCache", "Lorg/sonarsource/kotlin/plugin/caching/ContentHashCache;", "sonar-kotlin-plugin"})
public final class KotlinSensor
extends AbstractKotlinSensor {
    @NotNull
    private final FileLinesContextFactory fileLinesContextFactory;
    @NotNull
    private final NoSonarFilter noSonarFilter;
    @NotNull
    private final KotlinProjectSensor kotlinProjectSensor;

    public KotlinSensor(@NotNull CheckFactory checkFactory, @NotNull FileLinesContextFactory fileLinesContextFactory, @NotNull NoSonarFilter noSonarFilter, @NotNull KotlinLanguage language, @NotNull KotlinProjectSensor kotlinProjectSensor, @NotNull KotlinPluginExtensionsProvider[] extensionsProviders) {
        Intrinsics.checkNotNullParameter(checkFactory, "checkFactory");
        Intrinsics.checkNotNullParameter(fileLinesContextFactory, "fileLinesContextFactory");
        Intrinsics.checkNotNullParameter(noSonarFilter, "noSonarFilter");
        Intrinsics.checkNotNullParameter((Object)language, "language");
        Intrinsics.checkNotNullParameter(kotlinProjectSensor, "kotlinProjectSensor");
        Intrinsics.checkNotNullParameter(extensionsProviders, "extensionsProviders");
        super(checkFactory, KotlinSensorKt.access$instantiateRules(checkFactory, extensionsProviders), language, KotlinCheckListKt.getKOTLIN_CHECKS());
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.noSonarFilter = noSonarFilter;
        this.kotlinProjectSensor = kotlinProjectSensor;
    }

    public void describe(@NotNull SensorDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        descriptor2.onlyOnLanguage(this.getLanguage().getKey()).name(this.getLanguage().getName() + " Sensor");
    }

    @Override
    @NotNull
    public AbstractKotlinSensorExecuteContext getExecuteContext(@NotNull SensorContext sensorContext, @NotNull Iterable<? extends InputFile> filesToAnalyze, @NotNull ProgressReport progressReport, @NotNull List<String> filenames) {
        Intrinsics.checkNotNullParameter(sensorContext, "sensorContext");
        Intrinsics.checkNotNullParameter(filesToAnalyze, "filesToAnalyze");
        Intrinsics.checkNotNullParameter(progressReport, "progressReport");
        Intrinsics.checkNotNullParameter(filenames, "filenames");
        List<KotlinFileVisitor> list = this.visitors(sensorContext);
        Logger logger = KotlinSensorKt.access$getLOG$p();
        return new AbstractKotlinSensorExecuteContext(sensorContext, filesToAnalyze, progressReport, filenames, (List<? extends KotlinFileVisitor>)list, logger){
            private final List<String> classpath;
            {
                Intrinsics.checkNotNull($super_call_param$2);
                super($sensorContext, $filesToAnalyze, $progressReport, $super_call_param$1, $filenames, $super_call_param$2);
                String[] stringArray = $sensorContext.config().getStringArray("sonar.java.binaries");
                Intrinsics.checkNotNullExpressionValue(stringArray, "getStringArray(...)");
                Collection collection = ArraysKt.toList((Object[])stringArray);
                String[] stringArray2 = $sensorContext.config().getStringArray("sonar.java.libraries");
                Intrinsics.checkNotNullExpressionValue(stringArray2, "getStringArray(...)");
                this.classpath = CollectionsKt.plus(collection, (Iterable)ArraysKt.toList((Object[])stringArray2));
            }

            public List<String> getClasspath() {
                return this.classpath;
            }
        };
    }

    private final List<KotlinFileVisitor> visitors(SensorContext sensorContext) {
        List<KotlinFileVisitor> list;
        if (sensorContext.runtime().getProduct() == SonarProduct.SONARLINT) {
            KotlinFileVisitor[] kotlinFileVisitorArray = new KotlinFileVisitor[]{new IssueSuppressionVisitor(), new MetricVisitor(this.fileLinesContextFactory, this.noSonarFilter, this.kotlinProjectSensor.getTelemetryData()), new KtChecksVisitor(this.getChecks())};
            list = CollectionsKt.listOf(kotlinFileVisitorArray);
        } else {
            KotlinFileVisitor[] kotlinFileVisitorArray = new KotlinFileVisitor[]{new IssueSuppressionVisitor(), new MetricVisitor(this.fileLinesContextFactory, this.noSonarFilter, this.kotlinProjectSensor.getTelemetryData()), new KtChecksVisitor(this.getChecks()), new CopyPasteDetector(), new SyntaxHighlighter()};
            list = CollectionsKt.listOf(kotlinFileVisitorArray);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterable<InputFile> getFilesToAnalyse(@NotNull SensorContext sensorContext) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter(sensorContext, "sensorContext");
        FileSystem fileSystem = sensorContext.fileSystem();
        Intrinsics.checkNotNullExpressionValue(fileSystem, "fileSystem(...)");
        FileSystem fileSystem2 = fileSystem;
        FilePredicate[] filePredicateArray = new FilePredicate[]{fileSystem2.predicates().hasLanguage(this.getLanguage().getKey()), fileSystem2.predicates().hasType(InputFile.Type.MAIN), fileSystem2.predicates().not(fileSystem2.predicates().hasExtension("kts"))};
        FilePredicate mainFilePredicate = fileSystem2.predicates().and(filePredicateArray);
        Iterable mainFiles = fileSystem2.inputFiles(mainFilePredicate);
        boolean bl = false;
        if (this.canSkipUnchangedFiles(sensorContext) && sensorContext.runtime().getProduct() != SonarProduct.SONARLINT) {
            List list;
            void $this$filterTo$iv$iv;
            ContentHashCache contentHashCache = ContentHashCache.Companion.of(sensorContext);
            KotlinSensorKt.access$getLOG$p().debug("The Kotlin analyzer is running in a context where it can skip unchanged files.");
            int totalFiles = 0;
            Intrinsics.checkNotNull(mainFiles);
            Iterable $this$filter$iv = mainFiles;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                InputFile it = (InputFile)element$iv$iv;
                boolean bl2 = false;
                ++totalFiles;
                Intrinsics.checkNotNull(it);
                if (!(this.fileHasChanged(it, contentHashCache) || !this.reuseCPDTokens(it, sensorContext))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List it = list = (List)destination$iv$iv;
            boolean bl3 = false;
            KotlinSensorKt.access$getLOG$p().info("Only analyzing " + it.size() + " changed Kotlin files out of " + totalFiles + ".");
            iterable = list;
        } else {
            KotlinSensorKt.access$getLOG$p().debug("The Kotlin analyzer is running in a context where unchanged files cannot be skipped.");
            iterable = mainFiles;
        }
        Intrinsics.checkNotNullExpressionValue(iterable, "let(...)");
        return iterable;
    }

    private final boolean reuseCPDTokens(InputFile inputFile, SensorContext sensorContext) {
        boolean bl;
        if (!ApiExtensionsKt.hasCacheEnabled(sensorContext)) {
            return false;
        }
        ReadCache previousCache = sensorContext.previousCache();
        Intrinsics.checkNotNull(previousCache);
        List<CPDToken> list = CachingKt.loadCPDTokens(previousCache, inputFile);
        if (list != null) {
            NewCpdTokens newCpdTokens;
            List<CPDToken> previousTokens = list;
            boolean bl2 = false;
            NewCpdTokens $this$reuseCPDTokens_u24lambda_u246_u24lambda_u244 = newCpdTokens = sensorContext.newCpdTokens().onFile(inputFile);
            boolean bl3 = false;
            Iterable $this$forEach$iv = previousTokens;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CPDToken it = (CPDToken)element$iv;
                boolean bl4 = false;
                $this$reuseCPDTokens_u24lambda_u246_u24lambda_u244.addToken(it.getRange(), it.getText());
            }
            $this$reuseCPDTokens_u24lambda_u246_u24lambda_u244.save();
            WriteCache nextCache = sensorContext.nextCache();
            try {
                Intrinsics.checkNotNull(nextCache);
                CachingKt.copyCPDTokensFromPrevious(nextCache, inputFile);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logger logger = KotlinSensorKt.access$getLOG$p();
                Intrinsics.checkNotNullExpressionValue(logger, "access$getLOG$p(...)");
                LoggerExtensionsKt.trace(logger, () -> KotlinSensor.reuseCPDTokens$lambda$6$lambda$5(inputFile));
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean canSkipUnchangedFiles(SensorContext sensorContext) {
        Object object;
        Optional optional = sensorContext.config().getBoolean("sonar.kotlin.skipUnchanged");
        Intrinsics.checkNotNullExpressionValue(optional, "getBoolean(...)");
        Optional $this$getOrElse$iv = optional;
        boolean $i$f$getOrElse = false;
        if ($this$getOrElse$iv.isPresent()) {
            object = $this$getOrElse$iv.get();
        } else {
            boolean bl;
            boolean bl2 = false;
            try {
                bl = sensorContext.canSkipUnchangedFiles();
            }
            catch (IncompatibleClassChangeError incompatibleClassChangeError) {
                bl = false;
            }
            object = bl;
        }
        return (Boolean)object;
    }

    private final boolean fileHasChanged(InputFile inputFile, ContentHashCache contentHashCache) {
        ContentHashCache contentHashCache2 = contentHashCache;
        return contentHashCache2 != null ? contentHashCache2.hasDifferentContentCached(inputFile) : inputFile.status() != InputFile.Status.SAME;
    }

    private static final String reuseCPDTokens$lambda$6$lambda$5(InputFile $inputFile) {
        return "Unable to save the CPD tokens of file " + $inputFile + " for the next analysis.";
    }
}

