/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.config;

import java.util.Optional;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.api.server.ServerSide;
import org.sonarsource.api.sonarlint.SonarLintSide;

@ScannerSide
@ServerSide
@ComputeEngineSide
@SonarLintSide
public interface Configuration {
    public Optional<String> get(String var1);

    public boolean hasKey(String var1);

    public String[] getStringArray(String var1);

    default public Optional<Boolean> getBoolean(String key) {
        return this.get(key).map(String::trim).map(Boolean::parseBoolean);
    }

    default public Optional<Integer> getInt(String key) {
        try {
            return this.get(key).map(String::trim).map(Integer::parseInt);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException(String.format("The property '%s' is not an int value: %s", key, e.getMessage()));
        }
    }

    default public Optional<Long> getLong(String key) {
        try {
            return this.get(key).map(String::trim).map(Long::parseLong);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException(String.format("The property '%s' is not an long value: %s", key, e.getMessage()));
        }
    }

    default public Optional<Float> getFloat(String key) {
        try {
            return this.get(key).map(String::trim).map(Float::valueOf);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException(String.format("The property '%s' is not an float value: %s", key, e.getMessage()));
        }
    }

    default public Optional<Double> getDouble(String key) {
        try {
            return this.get(key).map(String::trim).map(Double::valueOf);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException(String.format("The property '%s' is not an double value: %s", key, e.getMessage()));
        }
    }
}

