/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.statement.BlockTree;
import org.sonar.plugins.php.api.tree.statement.IfStatementTree;
import org.sonar.plugins.php.api.tree.statement.StatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1066")
public class CollapsibleIfStatementCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1066";
    private static final String MESSAGE = "Merge this if statement with the enclosing one.";

    @Override
    public void visitIfStatement(IfStatementTree tree) {
        StatementTree singleStatement;
        super.visitIfStatement(tree);
        if (!CollapsibleIfStatementCheck.hasElseOrElseIf(tree) && (singleStatement = CollapsibleIfStatementCheck.getSingleNestedStatement(tree)) != null && CollapsibleIfStatementCheck.isIfStatementWithoutElse(singleStatement)) {
            this.context().newIssue(this, ((IfStatementTree)singleStatement).ifToken(), MESSAGE);
        }
    }

    private static boolean isIfStatementWithoutElse(StatementTree statement) {
        return statement.is(Tree.Kind.IF_STATEMENT, Tree.Kind.ALTERNATIVE_IF_STATEMENT) && !CollapsibleIfStatementCheck.hasElseOrElseIf((IfStatementTree)statement);
    }

    @Nullable
    private static StatementTree getSingleNestedStatement(IfStatementTree ifStatement) {
        if (ifStatement.statements().size() == 1) {
            StatementTree statement = ifStatement.statements().get(0);
            if (statement.is(Tree.Kind.BLOCK)) {
                BlockTree blockTree = (BlockTree)statement;
                if (blockTree.statements().size() == 1) {
                    return blockTree.statements().get(0);
                }
            } else {
                return statement;
            }
        }
        return null;
    }

    private static boolean hasElseOrElseIf(IfStatementTree ifStatement) {
        return ifStatement.elseClause() != null || !ifStatement.elseifClauses().isEmpty();
    }
}

