/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.FunctionTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.php.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.php.api.visitors.PHPSubscriptionCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;
import org.sonar.plugins.php.api.visitors.PreciseIssue;

@Rule(key="S3801")
public class ConsistentFunctionReturnCheck
extends PHPSubscriptionCheck {
    public static final String KEY = "S3801";
    private static final String MESSAGE = "Refactor this function to use \"return\" consistently.";
    private static final String MESSAGE_WITH_VALUE = "Return with value.";
    private static final String MESSAGE_WITHOUT_VALUE = "Return without value.";

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.METHOD_DECLARATION, Tree.Kind.FUNCTION_EXPRESSION);
    }

    @Override
    public void visitNode(Tree tree) {
        long numberEmptyReturn;
        FunctionTree functionTree = (FunctionTree)tree;
        List<ReturnStatementTree> returnStatements = ConsistentFunctionReturnCheck.getReturnedStatements(functionTree.body());
        int numberReturn = returnStatements.size();
        if (numberReturn > 1 && (numberEmptyReturn = returnStatements.stream().map(ReturnStatementTree::expression).filter(Objects::isNull).count()) > 0L && numberEmptyReturn != (long)numberReturn) {
            PreciseIssue issue = this.context().newIssue(this, ConsistentFunctionReturnCheck.functionName(tree), MESSAGE);
            returnStatements.forEach(returnStatement -> ConsistentFunctionReturnCheck.addSecondaryLocation(issue, returnStatement));
        }
    }

    private static Tree functionName(Tree tree) {
        if (tree.is(Tree.Kind.FUNCTION_DECLARATION)) {
            return ((FunctionDeclarationTree)tree).name();
        }
        if (tree.is(Tree.Kind.METHOD_DECLARATION)) {
            return ((MethodDeclarationTree)tree).name();
        }
        return ((FunctionExpressionTree)tree).functionToken();
    }

    private static List<ReturnStatementTree> getReturnedStatements(Tree body) {
        ReturnStatementCollector visitor = new ReturnStatementCollector();
        body.accept(visitor);
        return visitor.returnStatements;
    }

    private static void addSecondaryLocation(PreciseIssue issue, ReturnStatementTree returnStatement) {
        String secondaryLocation = returnStatement.expression() != null ? MESSAGE_WITH_VALUE : MESSAGE_WITHOUT_VALUE;
        issue.secondary(returnStatement, secondaryLocation);
    }

    private static class ReturnStatementCollector
    extends PHPVisitorCheck {
        List<ReturnStatementTree> returnStatements = new ArrayList<ReturnStatementTree>();

        private ReturnStatementCollector() {
        }

        @Override
        public void visitReturnStatement(ReturnStatementTree tree) {
            this.returnStatements.add(tree);
            super.visitReturnStatement(tree);
        }

        @Override
        public void visitClassDeclaration(ClassDeclarationTree tree) {
        }

        @Override
        public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        }

        @Override
        public void visitFunctionExpression(FunctionExpressionTree tree) {
        }
    }
}

