/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S2043")
public class DirectlyAccessingSuperGlobalCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "Do not access \"%s\" directly.";
    public static final String KEY = "S2043";
    private static final Set<String> SUPER_GLOBAL_REQUIRING_SANITIZATION = Set.of("$_COOKIE", "$_ENV", "$_FILES", "$_GET", "$_POST", "$_REQUEST", "$_SERVER");

    @Override
    public void visitVariableIdentifier(VariableIdentifierTree tree) {
        this.checkVariable(tree.variableExpression().token());
        super.visitVariableIdentifier(tree);
    }

    private void checkVariable(SyntaxToken variable) {
        String name = variable.text();
        if (SUPER_GLOBAL_REQUIRING_SANITIZATION.contains(name)) {
            this.context().newIssue(this, variable, String.format(MESSAGE, name));
        }
    }
}

