/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.checks.utils.SyntacticEquivalence;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.DeclaredTypeTree;
import org.sonar.plugins.php.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.FunctionTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ReturnTypeClauseTree;
import org.sonar.plugins.php.api.tree.expression.AnonymousClassTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.NameIdentifierTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.statement.BlockTree;
import org.sonar.plugins.php.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.php.api.tree.statement.StatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S4144")
public class DuplicatedMethodCheck
extends PHPVisitorCheck {
    private static final String ISSUE_MSG = "Update this method so that its implementation is not identical to \"%s\" on line %d.";
    private static final Function<FunctionTree, NameIdentifierTree> METHOD_TO_NAME = f -> ((MethodDeclarationTree)f).name();
    private static final Function<FunctionTree, NameIdentifierTree> FUNCTION_TO_NAME = f -> ((FunctionDeclarationTree)f).name();
    private static final int MINIMUM_NUMBER_OF_STATEMENTS = 2;
    private final Deque<List<MethodDeclarationTree>> methods = new LinkedList<List<MethodDeclarationTree>>();
    private final List<FunctionDeclarationTree> functions = new ArrayList<FunctionDeclarationTree>();

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        this.functions.clear();
        this.methods.clear();
        super.visitCompilationUnit(tree);
        this.checkDuplications(this.functions, FUNCTION_TO_NAME);
    }

    @Override
    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        if (tree.body().statements().size() >= 2) {
            this.functions.add(tree);
        }
        super.visitFunctionDeclaration(tree);
    }

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        if (DuplicatedMethodCheck.isDuplicateCandidate(tree)) {
            this.methods.peek().add(tree);
        }
        super.visitMethodDeclaration(tree);
    }

    private static boolean isDuplicateCandidate(MethodDeclarationTree tree) {
        return tree.body().is(Tree.Kind.BLOCK) && (((BlockTree)tree.body()).statements().size() >= 2 || DuplicatedMethodCheck.isNonTrivialAccessor(tree));
    }

    private static boolean isNonTrivialAccessor(MethodDeclarationTree tree) {
        String methodName = tree.name().text();
        List<StatementTree> statements = ((BlockTree)tree.body()).statements();
        boolean isAccessor = statements.size() == 1 && (methodName.startsWith("set") || methodName.startsWith("get") || methodName.startsWith("is"));
        return isAccessor && !DuplicatedMethodCheck.isTrivialStatement(statements.get(0));
    }

    private static boolean isTrivialStatement(StatementTree statement) {
        if (statement.is(Tree.Kind.RETURN_STATEMENT)) {
            ExpressionTree expression = ((ReturnStatementTree)statement).expression();
            return expression != null && (CheckUtils.isEmptyArrayConstructor(expression) || expression.is(Tree.Kind.NEW_EXPRESSION, Tree.Kind.NULL_LITERAL));
        }
        return statement.is(Tree.Kind.THROW_STATEMENT);
    }

    @Override
    public void visitClassDeclaration(ClassDeclarationTree tree) {
        this.methods.push(new ArrayList());
        super.visitClassDeclaration(tree);
        this.checkDuplications(this.methods.pop(), METHOD_TO_NAME);
    }

    @Override
    public void visitAnonymousClass(AnonymousClassTree tree) {
        this.methods.push(new ArrayList());
        super.visitAnonymousClass(tree);
        this.checkDuplications(this.methods.pop(), METHOD_TO_NAME);
    }

    private void checkDuplications(List<? extends FunctionTree> functionDeclarations, Function<FunctionTree, NameIdentifierTree> toName) {
        HashSet reported = new HashSet();
        for (int i = 0; i < functionDeclarations.size(); ++i) {
            FunctionTree func = functionDeclarations.get(i);
            SyntaxToken methodIdentifier = toName.apply(func).token();
            List<StatementTree> methodBody = ((BlockTree)func.body()).statements();
            functionDeclarations.stream().skip((long)i + 1L).filter(m -> !reported.contains(m)).filter(m -> DuplicatedMethodCheck.haveSameParametersAndReturnType(func, m)).filter(m -> SyntacticEquivalence.areSyntacticallyEquivalent(methodBody.iterator(), ((BlockTree)m.body()).statements().iterator())).forEach(m -> {
                this.context().newIssue(this, (Tree)toName.apply((FunctionTree)m), String.format(ISSUE_MSG, methodIdentifier.text(), methodIdentifier.line())).secondary(methodIdentifier, "original implementation");
                reported.add(m);
            });
        }
    }

    private static boolean haveSameParametersAndReturnType(FunctionTree f1, FunctionTree f2) {
        return f1.parameters().parameters().size() == f2.parameters().parameters().size() && SyntacticEquivalence.areSyntacticallyEquivalent(DuplicatedMethodCheck.declaredTypeTreeOrNull(f1), DuplicatedMethodCheck.declaredTypeTreeOrNull(f2));
    }

    private static DeclaredTypeTree declaredTypeTreeOrNull(FunctionTree functionTree) {
        return Optional.ofNullable(functionTree.returnTypeClause()).map(ReturnTypeClauseTree::declaredType).orElse(null);
    }
}

