/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.Collections;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.php.tree.TreeUtils;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.utils.collections.ListUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.FunctionTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.php.api.tree.statement.BlockTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1186")
public class EmptyMethodCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "Add a nested comment explaining why this %s is empty, throw an Exception or complete the implementation.";
    private static final int MIN_WORD_CHARS = 3;
    private static final Pattern VALUABLE_COMMENT_PATTERN = Pattern.compile("\\w{3}");

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        if (!(!tree.body().is(Tree.Kind.BLOCK) || EmptyMethodCheck.hasValuableBody((BlockTree)tree.body()) || EmptyMethodCheck.isClassAbstract(tree) || EmptyMethodCheck.hasCommentAbove(((PHPTree)((Object)tree)).getFirstToken()) || EmptyMethodCheck.isConstructorPropertyPromotion(tree))) {
            this.commitIssue(tree, "method");
        }
        super.visitMethodDeclaration(tree);
    }

    @Override
    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        if (!EmptyMethodCheck.hasValuableBody(tree.body()) && !EmptyMethodCheck.hasCommentAbove(((PHPTree)((Object)tree)).getFirstToken())) {
            this.commitIssue(tree, "function");
        }
        super.visitFunctionDeclaration(tree);
    }

    private static boolean hasCommentAbove(SyntaxToken token) {
        int beforeDeclarationLine = token.line() - 1;
        SyntaxTrivia trivia = ListUtils.getLast(token.trivias(), null);
        return trivia != null && beforeDeclarationLine == trivia.endLine() && EmptyMethodCheck.isValuableComment(trivia);
    }

    private static boolean isClassAbstract(MethodDeclarationTree tree) {
        ClassDeclarationTree classTree = (ClassDeclarationTree)TreeUtils.findAncestorWithKind((Tree)tree, Collections.singletonList(Tree.Kind.CLASS_DECLARATION));
        return classTree != null && classTree.isAbstract();
    }

    private static boolean hasValuableBody(BlockTree tree) {
        if (!tree.statements().isEmpty()) {
            return true;
        }
        SyntaxTrivia trivia = ListUtils.getLast(tree.closeCurlyBraceToken().trivias(), null);
        return trivia != null && EmptyMethodCheck.isValuableComment(trivia);
    }

    private static boolean isValuableComment(SyntaxToken trivia) {
        return VALUABLE_COMMENT_PATTERN.matcher(trivia.text()).find();
    }

    private static boolean isConstructorPropertyPromotion(MethodDeclarationTree tree) {
        return tree.name().text().equalsIgnoreCase("__construct") && tree.parameters().parameters().stream().anyMatch(p -> p.visibility() != null);
    }

    private void commitIssue(FunctionTree tree, String type) {
        this.context().newIssue(this, tree, String.format(MESSAGE, type));
    }
}

