/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.php.checks.phpini.PhpIniBoolean;
import org.sonar.php.checks.phpini.PhpIniFiles;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.ini.PhpIniCheck;
import org.sonar.php.ini.PhpIniIssue;
import org.sonar.php.ini.tree.PhpIniFile;
import org.sonar.php.tree.impl.declaration.ClassNamespaceNameTreeImpl;
import org.sonar.plugins.php.api.symbols.QualifiedName;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.MemberAccessTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S3330")
public class HttpOnlyCheck
extends PHPVisitorCheck
implements PhpIniCheck {
    private static final String MESSAGE_PHP_INI = "Set the \"session.cookie_httponly\" property to \"true\" if needed.";
    private static final String MESSAGE = "Make sure creating this cookie without the \"httpOnly\" flag is safe here.";
    private static final List<String> SET_COOKIE_FUNCTIONS = Arrays.asList("setcookie", "setrawcookie");
    private static final QualifiedName SYMFONY_COOKIE = QualifiedName.qualifiedName("Symfony\\Component\\HttpFoundation\\Cookie");

    @Override
    public List<PhpIniIssue> analyze(PhpIniFile phpIniFile) {
        return PhpIniFiles.checkRequiredBoolean(phpIniFile, "session.cookie_httponly", PhpIniBoolean.ON, MESSAGE_PHP_INI, MESSAGE_PHP_INI);
    }

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        Optional<CallArgumentTree> argument;
        if (HttpOnlyCheck.isSetCookie(tree)) {
            argument = CheckUtils.argument(tree, "httponly", 6);
            if (argument.isPresent()) {
                this.createIssueIfHttpOnlyIsFalse(argument.get().value(), tree);
            } else if (tree.callArguments().size() != 3) {
                this.createIssueIfCookieValueIsNotHardcoded(tree);
            }
        }
        if (this.isSymfonyCookieCreation(tree) && (argument = CheckUtils.argument(tree, "httpOnly", 6)).isPresent()) {
            this.createIssueIfHttpOnlyIsFalse(argument.get().value(), tree);
        }
        super.visitFunctionCall(tree);
    }

    private static boolean isSetCookie(FunctionCallTree tree) {
        String functionName = CheckUtils.getLowerCaseFunctionName(tree);
        return functionName != null && SET_COOKIE_FUNCTIONS.contains(functionName);
    }

    private boolean isSymfonyCookieCreation(FunctionCallTree tree) {
        ExpressionTree callee = tree.callee();
        if (callee.is(Tree.Kind.CLASS_MEMBER_ACCESS)) {
            MemberAccessTree memberAccessTree = (MemberAccessTree)callee;
            ExpressionTree receiver = memberAccessTree.object();
            String method = CheckUtils.nameOf(memberAccessTree.member());
            return "create".equals(method) && receiver.is(Tree.Kind.NAMESPACE_NAME) && SYMFONY_COOKIE.equals(this.getFullyQualifiedName((NamespaceNameTree)receiver));
        }
        if (callee instanceof ClassNamespaceNameTreeImpl) {
            ClassNamespaceNameTreeImpl classNamespaceName = (ClassNamespaceNameTreeImpl)callee;
            return classNamespaceName.symbol().qualifiedName().equals(SYMFONY_COOKIE);
        }
        return false;
    }

    private void createIssueIfHttpOnlyIsFalse(ExpressionTree argument, FunctionCallTree tree) {
        if (CheckUtils.isFalseValue(argument)) {
            this.context().newIssue(this, tree.callee(), MESSAGE).secondary(argument, null);
        }
    }

    private void createIssueIfCookieValueIsNotHardcoded(FunctionCallTree tree) {
        Optional<CallArgumentTree> cookieValue = CheckUtils.argument(tree, "value", 1);
        if (cookieValue.isEmpty() || HttpOnlyCheck.isHardcodedOrNullCookieValue(cookieValue.get())) {
            return;
        }
        this.context().newIssue(this, tree.callee(), MESSAGE);
    }

    private static boolean isHardcodedOrNullCookieValue(CallArgumentTree cookieValue) {
        return cookieValue.value().is(Tree.Kind.NULL_LITERAL) || cookieValue.value().is(Tree.Kind.REGULAR_STRING_LITERAL);
    }
}

