/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S113")
public class MissingNewLineAtEOFCheck
extends PHPVisitorCheck {
    public static final String KEY = "S113";
    private static final String MESSAGE = "Add a new line at the end of this file.";

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        SyntaxToken eofToken = tree.eofToken();
        if (eofToken.column() != 0 || eofToken.line() == 1) {
            this.context().newFileIssue(this, MESSAGE);
        }
    }
}

