/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.ScriptTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1757")
public class OpeningPHPTagCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "Change this opening tag to either \"<?php\" or \"<?=\".";
    private static final String LONG_TAG = "<?php";
    private static final String SHORT_ECHO_TAG = "<?=";
    private static final String SHORT_TAG = "<?";

    @Override
    public void visitScript(ScriptTree tree) {
        String openingTagWithContentBefore = tree.fileOpeningTagToken().text();
        if (!OpeningPHPTagCheck.isAuthorisedTag(openingTagWithContentBefore)) {
            this.context().newLineIssue(this, OpeningPHPTagCheck.getLineToReport(tree), MESSAGE);
        }
    }

    private static int getLineToReport(ScriptTree tree) {
        return tree.fileOpeningTagToken().endLine();
    }

    private static boolean isAuthorisedTag(String openingTagWithContentBefore) {
        return openingTagWithContentBefore.endsWith(LONG_TAG) || openingTagWithContentBefore.endsWith(SHORT_ECHO_TAG) || !openingTagWithContentBefore.endsWith(SHORT_TAG);
    }
}

