/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.php.symbols.ClassSymbol;
import org.sonar.php.symbols.MethodSymbol;
import org.sonar.php.symbols.Parameter;
import org.sonar.php.symbols.Symbol;
import org.sonar.php.tree.symbols.HasClassSymbol;
import org.sonar.php.tree.symbols.HasMethodSymbol;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ClassMemberTree;
import org.sonar.plugins.php.api.tree.declaration.ClassTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ParameterTree;
import org.sonar.plugins.php.api.tree.expression.AnonymousClassTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.MemberAccessTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.tree.statement.BlockTree;
import org.sonar.plugins.php.api.tree.statement.ExpressionStatementTree;
import org.sonar.plugins.php.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.php.api.tree.statement.StatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1185")
public class OverridingMethodSimplyCallParentCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "Remove this method \"%s\" to simply inherit it.";

    @Override
    public void visitClassDeclaration(ClassDeclarationTree tree) {
        super.visitClassDeclaration(tree);
        this.visitClass(tree);
    }

    @Override
    public void visitAnonymousClass(AnonymousClassTree tree) {
        super.visitAnonymousClass(tree);
        this.visitClass(tree);
    }

    private void visitClass(ClassTree tree) {
        if (tree.superClass() != null) {
            ClassSymbol superClassSymbol = ((HasClassSymbol)((Object)tree)).symbol().superClass().get();
            for (ClassMemberTree member : tree.members()) {
                if (!member.is(Tree.Kind.METHOD_DECLARATION)) continue;
                this.checkMethod((MethodDeclarationTree)member, superClassSymbol);
            }
        }
    }

    private void checkMethod(MethodDeclarationTree method, ClassSymbol superClass) {
        BlockTree blockTree;
        if (method.body().is(Tree.Kind.BLOCK) && (blockTree = (BlockTree)method.body()).statements().size() == 1) {
            StatementTree statementTree = blockTree.statements().get(0);
            ExpressionTree expressionTree = null;
            if (statementTree.is(Tree.Kind.EXPRESSION_STATEMENT)) {
                expressionTree = ((ExpressionStatementTree)statementTree).expression();
            } else if (statementTree.is(Tree.Kind.RETURN_STATEMENT)) {
                expressionTree = ((ReturnStatementTree)statementTree).expression();
            }
            this.checkExpression(expressionTree, method, superClass);
        }
    }

    private void checkExpression(@Nullable ExpressionTree expressionTree, MethodDeclarationTree method, ClassSymbol superClass) {
        FunctionCallTree functionCallTree;
        if (expressionTree != null && expressionTree.is(Tree.Kind.FUNCTION_CALL) && (functionCallTree = (FunctionCallTree)expressionTree).callee().is(Tree.Kind.CLASS_MEMBER_ACCESS)) {
            boolean isCallingSuperclassMethodWithSameNameAndArguments;
            MemberAccessTree memberAccessTree = (MemberAccessTree)functionCallTree.callee();
            String methodName = method.name().text();
            boolean bl = isCallingSuperclassMethodWithSameNameAndArguments = OverridingMethodSimplyCallParentCheck.isSuperClassReference(memberAccessTree.object(), superClass.qualifiedName().toString()) && memberAccessTree.member().toString().equals(methodName) && OverridingMethodSimplyCallParentCheck.isFunctionCalledWithSameArgumentsAsDeclared(functionCallTree, method);
            if (isCallingSuperclassMethodWithSameNameAndArguments) {
                boolean duplicatesDeclarationFromSuper = Stream.iterate(superClass, Objects::nonNull, c -> c.superClass().orElse(null)).flatMap(c -> c.declaredMethods().stream()).anyMatch(ms -> ms.name().equalsIgnoreCase(methodName) && OverridingMethodSimplyCallParentCheck.hasSameVisibilityAs(method, ms) && OverridingMethodSimplyCallParentCheck.hasSameParameterList(method, ms));
                boolean isInheritanceChainUnresolvable = Stream.iterate(superClass, Objects::nonNull, c -> c.superClass().orElse(null)).anyMatch(Symbol::isUnknownSymbol);
                if (isInheritanceChainUnresolvable || duplicatesDeclarationFromSuper) {
                    String message = String.format(MESSAGE, methodName);
                    this.context().newIssue(this, method.name(), message);
                }
            }
        }
    }

    private static boolean hasSameParameterList(MethodDeclarationTree method, MethodSymbol other) {
        MethodSymbol methodSymbol = ((HasMethodSymbol)((Object)method)).symbol();
        List<Parameter> parameters = methodSymbol.parameters();
        List<Parameter> otherParameters = other.parameters();
        if (parameters.size() != otherParameters.size()) {
            return false;
        }
        for (int i = 0; i < parameters.size(); ++i) {
            if (parameters.get(i).equals(otherParameters.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean hasSameVisibilityAs(MethodDeclarationTree method, MethodSymbol other) {
        return ((HasMethodSymbol)((Object)method)).symbol().visibility() == other.visibility();
    }

    private static boolean isFunctionCalledWithSameArgumentsAsDeclared(FunctionCallTree functionCallTree, MethodDeclarationTree method) {
        ArrayList<String> argumentNames = new ArrayList<String>();
        for (CallArgumentTree argument : functionCallTree.callArguments()) {
            if (!argument.value().is(Tree.Kind.VARIABLE_IDENTIFIER) || argument.name() != null) {
                return false;
            }
            argumentNames.add(((VariableIdentifierTree)argument.value()).variableExpression().text());
        }
        ArrayList<String> parameterNames = new ArrayList<String>();
        for (ParameterTree parameter : method.parameters().parameters()) {
            if (parameter.initValue() != null) {
                return false;
            }
            parameterNames.add(parameter.variableIdentifier().variableExpression().text());
        }
        return argumentNames.equals(parameterNames);
    }

    private static boolean isSuperClassReference(ExpressionTree tree, String superClass) {
        String str = tree.toString();
        return superClass.equalsIgnoreCase(str) || "parent".equalsIgnoreCase(str);
    }
}

