/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.php.metrics.LineVisitor;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ClassTree;
import org.sonar.plugins.php.api.tree.expression.AnonymousClassTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S2042")
public class TooManyLinesInClassCheck
extends PHPVisitorCheck {
    public static final String KEY = "S2042";
    private static final String MESSAGE = "Class \"%s\" has %s lines, which is greater than the %s authorized. Split it into smaller classes.";
    private static final String MESSAGE_ANONYMOUS_CLASS = "This anonymous class has %s lines, which is greater than the %s authorized. Split it into smaller classes.";
    private static final int DEFAULT = 200;
    @RuleProperty(key="maximumLinesThreshold", description="The maximum number of lines of code", defaultValue="200")
    public int maximumLinesThreshold = 200;

    @Override
    public void visitClassDeclaration(ClassDeclarationTree declaration) {
        this.checkClass(declaration);
        super.visitClassDeclaration(declaration);
    }

    @Override
    public void visitAnonymousClass(AnonymousClassTree tree) {
        this.checkClass(tree);
        super.visitAnonymousClass(tree);
    }

    private void checkClass(ClassTree tree) {
        int numberOfLines = LineVisitor.linesOfCode(tree);
        if (numberOfLines > this.maximumLinesThreshold) {
            String message = tree.is(Tree.Kind.ANONYMOUS_CLASS) ? String.format(MESSAGE_ANONYMOUS_CLASS, numberOfLines, this.maximumLinesThreshold) : String.format(MESSAGE, ((ClassDeclarationTree)tree).name().text(), numberOfLines, this.maximumLinesThreshold);
            this.context().newIssue(this, tree.classToken(), message);
        }
    }
}

