/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.php.symbols.ClassSymbol;
import org.sonar.php.symbols.MethodSymbol;
import org.sonar.php.symbols.Symbols;
import org.sonar.php.symbols.Visibility;
import org.sonar.php.tree.symbols.Scope;
import org.sonar.php.utils.SourceBuilder;
import org.sonar.plugins.php.api.symbols.Symbol;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.FunctionTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.php.api.tree.expression.IdentifierTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1172")
public class UnusedFunctionParametersCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1172";
    private static final String MESSAGE = "Remove the unused function parameter \"%s\".";
    private final Deque<Boolean> hasFuncGetArgsStack = new ArrayDeque<Boolean>();
    private List<IdentifierTree> constructorPromotedProperties = new ArrayList<IdentifierTree>();

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        String callee = SourceBuilder.build(tree.callee()).trim();
        if (callee.equals("func_get_args")) {
            this.hasFuncGetArgsStack.pop();
            this.hasFuncGetArgsStack.push(true);
        }
        super.visitFunctionCall(tree);
    }

    @Override
    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.hasFuncGetArgsStack.push(false);
        super.visitFunctionDeclaration(tree);
        if (!this.hasFuncGetArgsStack.pop().booleanValue()) {
            this.checkParameters(tree);
        }
    }

    @Override
    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.hasFuncGetArgsStack.push(false);
        super.visitFunctionExpression(tree);
        if (!this.hasFuncGetArgsStack.pop().booleanValue()) {
            this.checkParameters(tree);
        }
    }

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        this.hasFuncGetArgsStack.push(false);
        super.visitMethodDeclaration(tree);
        if (!UnusedFunctionParametersCheck.isExcluded(tree) && !this.hasFuncGetArgsStack.pop().booleanValue()) {
            this.collectConstructorPromotedProperties(tree);
            this.checkParameters(tree);
        }
        this.constructorPromotedProperties.clear();
    }

    private void checkParameters(FunctionTree tree) {
        Scope scope = this.context().symbolTable().getScopeFor(tree);
        if (scope != null && !scope.hasUnresolvedCompact()) {
            ArrayList<IdentifierTree> unused = new ArrayList<IdentifierTree>();
            for (Symbol symbol : scope.getSymbols(Symbol.Kind.PARAMETER)) {
                if (UnusedFunctionParametersCheck.isExcluded(symbol) || !symbol.usages().isEmpty() || this.constructorPromotedProperties.contains(symbol.declaration())) continue;
                unused.add(symbol.declaration());
            }
            for (IdentifierTree unusedParameter : unused) {
                this.context().newIssue(this, unusedParameter, String.format(MESSAGE, unusedParameter.text()));
            }
        }
    }

    private void collectConstructorPromotedProperties(MethodDeclarationTree tree) {
        if (tree.name().text().equalsIgnoreCase("__construct")) {
            this.constructorPromotedProperties = tree.parameters().parameters().stream().filter(p -> p.visibility() != null).map(p -> p.variableIdentifier().variableExpression()).collect(Collectors.toList());
        }
    }

    private static boolean isExcluded(MethodDeclarationTree tree) {
        MethodSymbol methodSymbol = Symbols.get(tree);
        return !tree.body().is(Tree.Kind.BLOCK) || !methodSymbol.isOverriding().isFalse() || methodSymbol.visibility() != Visibility.PRIVATE && methodSymbol.owner().is(ClassSymbol.Kind.ABSTRACT);
    }

    private static boolean isExcluded(Symbol symbol) {
        return symbol.name().chars().skip(1L).allMatch(c -> 95 == c);
    }
}

