/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.formatting;

import org.sonar.api.utils.Preconditions;
import org.sonar.php.api.PHPPunctuator;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;

public class TokenUtils {
    private TokenUtils() {
    }

    public static String buildIssueMsg(int nbSpace, String end) {
        return "Put " + (nbSpace > 1 ? "only " : "") + "one space " + end;
    }

    public static boolean isType(SyntaxToken token, PHPPunctuator ... types) {
        boolean isOneOfType = false;
        for (PHPPunctuator type : types) {
            isOneOfType |= type.getValue().equals(token.text());
        }
        return isOneOfType;
    }

    public static boolean isOnSameLine(SyntaxToken ... tokens) {
        Preconditions.checkArgument(tokens.length > 0);
        int lineRef = tokens[0].line();
        for (SyntaxToken token : tokens) {
            if (token.line() == lineRef) continue;
            return false;
        }
        return true;
    }

    protected static int getNbSpaceBetween(SyntaxToken token1, SyntaxToken token2) {
        int token1EndColumn = token1.column() + (token1.text().length() - 1);
        int tok2StartColumn = token2.column();
        return tok2StartColumn - token1EndColumn - 1;
    }
}

