/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.phpunit;

import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.checks.utils.PhpUnitCheck;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;

@Rule(key="S3360")
public class TestClassNameCheck
extends PhpUnitCheck {
    private static final String MESSAGE = "Rename this class to end with \"Test\" to ensure it will be executed by the PHPUnit CLI.";

    @Override
    protected void visitPhpUnitTestCase(ClassDeclarationTree tree) {
        if (!tree.isAbstract() && !CheckUtils.getLowerCaseClassName(tree).endsWith("test")) {
            this.newIssue(tree.name(), MESSAGE);
        }
    }
}

