/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.security;

import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S5328")
public class SessionFixationCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "Make sure the session ID being set is cryptographically secure and is not user-supplied.";

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        if (SessionFixationCheck.isFunctionCall(tree, "session_id") && this.hasArguments(tree) && !SessionFixationCheck.isFunctionCall(SessionFixationCheck.firstCallArgument(tree), "session_create_id")) {
            this.context().newIssue(this, tree, MESSAGE);
        }
        super.visitFunctionCall(tree);
    }

    private static boolean isFunctionCall(ExpressionTree expression, String expectedName) {
        return expression.is(Tree.Kind.FUNCTION_CALL) && expectedName.equals(CheckUtils.getLowerCaseFunctionName((FunctionCallTree)expression));
    }

    private static ExpressionTree firstCallArgument(FunctionCallTree call) {
        return ((CallArgumentTree)call.callArguments().get(0)).value();
    }

    private boolean hasArguments(FunctionCallTree tree) {
        return !tree.callArguments().isEmpty();
    }
}

