/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.utils;

import java.util.ArrayList;
import java.util.List;
import org.sonar.api.utils.Preconditions;
import org.sonar.plugins.php.api.tree.ScriptTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.php.api.tree.statement.IfStatementTree;
import org.sonar.plugins.php.api.tree.statement.StatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

public abstract class AbstractDuplicateBranchCheck
extends PHPVisitorCheck {
    protected List<IfStatementTree> checkedIfStatements;

    @Override
    public void visitScript(ScriptTree tree) {
        this.checkedIfStatements = new ArrayList<IfStatementTree>();
        super.visitScript(tree);
    }

    protected List<Tree> getClauses(IfStatementTree ifStatement) {
        Preconditions.checkArgument(ifStatement.is(Tree.Kind.IF_STATEMENT));
        ArrayList<Tree> clauses = new ArrayList<Tree>();
        clauses.add(ifStatement);
        clauses.addAll(ifStatement.elseifClauses());
        ElseClauseTree currentElseClause = ifStatement.elseClause();
        while (currentElseClause != null) {
            StatementTree statement = currentElseClause.statements().get(0);
            if (statement.is(Tree.Kind.IF_STATEMENT)) {
                IfStatementTree nestedIfStatement = (IfStatementTree)statement;
                clauses.add(nestedIfStatement);
                this.checkedIfStatements.add(nestedIfStatement);
                currentElseClause = nestedIfStatement.elseClause();
                continue;
            }
            clauses.add(currentElseClause);
            currentElseClause = null;
        }
        return clauses;
    }
}

