/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.wordpress;

import java.util.Collections;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.checks.wordpress.WordPressConfigVisitor;
import org.sonar.plugins.php.api.tree.ScriptTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;

@Rule(key="S6345")
public class WordPressExternalRequestsCheck
extends WordPressConfigVisitor {
    private static final String MESSAGE = "Make sure allowing external requests is intended.";
    private boolean configOccurred;

    @Override
    public void visitScript(ScriptTree tree) {
        this.configOccurred = false;
        super.visitScript(tree);
        if (!this.configOccurred) {
            this.context().newFileIssue(this, MESSAGE);
        }
    }

    @Override
    protected Set<String> configsToVisit() {
        return Collections.singleton("WP_HTTP_BLOCK_EXTERNAL");
    }

    @Override
    void visitConfigDeclaration(FunctionCallTree config) {
        this.configOccurred = true;
        WordPressExternalRequestsCheck.configValue(config).filter(CheckUtils::isFalseValue).ifPresent(v -> this.newIssue(config, MESSAGE));
    }
}

