/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.filters;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.CheckForNull;
import org.sonar.php.filters.PHPIssueFilter;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.AttributeGroupTree;
import org.sonar.plugins.php.api.tree.declaration.AttributeTree;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

public class SuppressWarningFilter
extends PHPVisitorCheck
implements PHPIssueFilter {
    private final SuppressedWarnings suppressedWarnings = new SuppressedWarnings();
    private static final String ARGUMENT_FORMAT = "\"[a-zA-Z0-9:]++\"";
    private static final String ARGUMENTS_FORMAT = "\"[a-zA-Z0-9:]++\"(?:\\s*+,\\s*+\"[a-zA-Z0-9:]++\")*+";
    private static final Pattern SUPPRESS_WARNING_COMMENT_PATTERN = Pattern.compile("@SuppressWarnings\\s*+\\(\\s*+(?<arguments>\"[a-zA-Z0-9:]++\"(?:\\s*+,\\s*+\"[a-zA-Z0-9:]++\")*+)\\s*+\\)");

    public void reset() {
        this.suppressedWarnings.clear();
    }

    @Override
    public boolean accept(String fileUri, String ruleName, int line) {
        return !this.suppressedWarnings.hasSuppressedWarnings(fileUri, ruleName, line);
    }

    @Override
    public void visitAttribute(AttributeTree tree) {
        List<String> rulesSuppressed = this.extractedSuppressedWarningsFromArgument(tree.arguments());
        AttributeGroupTree parent = (AttributeGroupTree)tree.getParent();
        PHPTree phpTreeParent = SuppressWarningFilter.findFarthestPhpTreeParent(parent.startToken());
        Optional.ofNullable(phpTreeParent).ifPresent(phpTree -> {
            Set<Integer> range = SuppressWarningFilter.computeLines(phpTree, parent.startToken(), parent.endToken());
            this.suppressedWarnings.addSuppressedWarning(this.getFileUri(), rulesSuppressed, range);
        });
        super.visitAttribute(tree);
    }

    public List<String> extractedSuppressedWarningsFromArgument(Collection<CallArgumentTree> arguments) {
        return arguments.stream().map(CallArgumentTree::value).filter(expr -> expr.is(Tree.Kind.REGULAR_STRING_LITERAL)).map(LiteralTree.class::cast).map(literal -> SuppressWarningFilter.stripDoubleQuotes(literal.value())).toList();
    }

    @Override
    public void visitToken(SyntaxToken token) {
        for (SyntaxTrivia trivia : token.trivias()) {
            String comment = SuppressWarningFilter.retrieveContents(trivia.text());
            this.processSuppressedWarningsInComment(token, comment);
        }
        super.visitToken(token);
    }

    private void processSuppressedWarningsInComment(SyntaxToken token, String comment) {
        Matcher matcher = SUPPRESS_WARNING_COMMENT_PATTERN.matcher(comment);
        if (matcher.find()) {
            PHPTree parent = SuppressWarningFilter.findFarthestPhpTreeParent(token);
            Set<Integer> range = SuppressWarningFilter.computeLines(parent, token, token);
            do {
                String arguments = matcher.group("arguments");
                Arrays.stream(arguments.split(",")).map(str -> SuppressWarningFilter.stripDoubleQuotes(str.trim())).forEach(ruleName -> this.suppressedWarnings.addSuppressedWarning(this.getFileUri(), (String)ruleName, range));
            } while (matcher.find());
        }
    }

    private static Set<Integer> computeLines(PHPTree phpTree, SyntaxToken startToken, SyntaxToken endToken) {
        int startLine = Optional.ofNullable(phpTree).map(PHPTree::getFirstToken).map(SyntaxToken::line).orElse(startToken.line());
        int endLine = Optional.ofNullable(phpTree).map(PHPTree::getLastToken).map(SyntaxToken::endLine).orElse(endToken.endLine());
        return IntStream.rangeClosed(startLine, endLine).boxed().collect(Collectors.toSet());
    }

    @CheckForNull
    private static PHPTree findFarthestPhpTreeParent(SyntaxToken token) {
        PHPTree result = null;
        for (Tree parent = token.getParent(); parent != null; parent = parent.getParent()) {
            PHPTree parentPhp = (PHPTree)parent;
            if (parentPhp.getFirstToken() != token) {
                return result;
            }
            result = parentPhp;
        }
        return result;
    }

    private String getFileUri() {
        return this.context().getPhpFile().uri().toString();
    }

    private static String retrieveContents(String comment) {
        if (comment.startsWith("//")) {
            return comment.substring(2);
        }
        if (comment.startsWith("#")) {
            return comment.substring(1);
        }
        return comment.substring(2, comment.length() - 2);
    }

    private static String stripDoubleQuotes(String str) {
        if (str.startsWith("\"") && str.endsWith("\"")) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    static class SuppressedWarnings {
        private final Map<String, Map<String, Set<Integer>>> suppressedRangePerRulesPerFile = new HashMap<String, Map<String, Set<Integer>>>();

        SuppressedWarnings() {
        }

        public void addSuppressedWarning(String fileUri, String ruleName, Set<Integer> range) {
            this.suppressedRangePerRulesPerFile.computeIfAbsent(fileUri, key -> new HashMap()).computeIfAbsent(ruleName, key -> new HashSet()).addAll(range);
        }

        public void addSuppressedWarning(String fileUri, Collection<String> ruleNames, Set<Integer> range) {
            ruleNames.forEach(ruleName -> this.addSuppressedWarning(fileUri, (String)ruleName, range));
        }

        public boolean hasSuppressedWarnings(String fileUri, String ruleName, int line) {
            return ((Set)this.suppressedRangePerRulesPerFile.getOrDefault(fileUri, Collections.emptyMap()).getOrDefault(ruleName, new HashSet())).contains(line);
        }

        public void clear() {
            this.suppressedRangePerRulesPerFile.clear();
        }
    }
}

