/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.parser;

import com.sonar.sslr.api.GenericTokenType;
import org.sonar.php.api.PHPKeyword;
import org.sonar.php.api.PHPPunctuator;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.grammar.LexerlessGrammarBuilder;
import org.sonar.sslr.parser.LexerlessGrammar;

public enum PHPLexicalGrammar implements GrammarRuleKey
{
    COMPILATION_UNIT,
    SCRIPT,
    FUNCTION_DECLARATION,
    CLASS_DECLARATION,
    INTERFACE_DECLARATION,
    TRAIT_DECLARATION,
    ENUM_DECLARATION,
    CLASS_MEMBER,
    ENUM_MEMBER,
    METHOD_DECLARATION,
    CLASS_VARIABLE_DECLARATION,
    CLASS_CONSTANT_DECLARATION,
    TRAIT_USE_STATEMENT,
    NAMESPACE_NAME,
    NAMESPACE_NAME_WITHOUT_SINGLE_KEYWORD,
    NS_SEPARATOR_WITHOUT_SPACE,
    INTERFACE_LIST,
    PARAMETER_LIST,
    PARAMETER,
    VARIABLE_DECLARATION,
    MEMBER_MODIFIER,
    CLASS_CONST_MODIFIER,
    VISIBILITY_MODIFIER,
    ASYMMETRIC_VISIBILITY_MODIFIER,
    MEMBER_CONST_DECLARATION,
    FUNCTION_CALL_ARGUMENT,
    PROPERTY_HOOK_LIST,
    PROPERTY_HOOK,
    PROPERTY_HOOK_FUNCTION_NAME,
    TRAIT_METHOD_REFERENCE_FULLY_QUALIFIED,
    TRAIT_METHOD_REFERENCE,
    TRAIT_ALIAS,
    TRAIT_PRECEDENCE,
    TYPE,
    TYPE_NAME,
    RETURN_TYPE_CLAUSE,
    UNION_TYPE,
    INTERSECTION_TYPE,
    DECLARED_TYPE,
    DNF_TYPE,
    DNF_INTERSECTION_TYPE,
    EOF,
    NOWDOC,
    HEREDOC,
    HEREDOC_BODY,
    NUMERIC_LITERAL,
    STRING_LITERAL,
    STRING_WITH_ENCAPS_VAR_CHARACTERS,
    STRING_CHARACTERS_EXECUTION,
    HEREDOC_STRING_CHARACTERS,
    ENCAPS_VAR_IDENTIFIER,
    REGULAR_VAR_IDENTIFIER,
    VARIABLE_IDENTIFIER,
    IDENTIFIER,
    IDENTIFIER_OR_KEYWORD,
    FILE_OPENING_TAG,
    ANYTHING_BUT_START_TAG,
    INLINE_HTML,
    KEYWORDS,
    SPACING,
    EOS,
    TOP_STATEMENT,
    STATEMENT,
    INNER_STATEMENT,
    BLOCK,
    EMPTY_STATEMENT,
    INLINE_HTML_STATEMENT,
    NAMESPACE_STATEMENT,
    DECLARE_STATEMENT,
    CONSTANT_DECLARATION,
    CONSTANT_VAR,
    USE_STATEMENT,
    USE_CLAUSE,
    GROUP_USE_CLAUSE,
    EXPRESSION_STATEMENT,
    EXPRESSION_LIST_STATEMENT,
    ECHO_STATEMENT,
    IF_STATEMENT,
    ELSEIF_CLAUSE,
    ELSE_CLAUSE,
    ALTERNATIVE_IF_STATEMENT,
    STANDARD_IF_STATEMENT,
    ALTERNATIVE_ELSEIF_CLAUSE,
    ALTERNATIVE_ELSE_CLAUSE,
    WHILE_STATEMENT,
    ALTERNATIVE_WHILE_STATEMENT,
    DO_WHILE_STATEMENT,
    FOR_STATEMENT,
    FOR_EXPR,
    FOREACH_STATEMENT,
    FOREACH_VARIABLE,
    MATCH_EXPRESSION,
    MATCH_CLAUSE,
    SWITCH_STATEMENT,
    SWITCH_CASE_CLAUSE,
    LABEL,
    BREAK_STATEMENT,
    CONTINUE_STATEMENT,
    RETURN_STATEMENT,
    THROW_STATEMENT,
    GOTO_STATEMENT,
    TRY_STATEMENT,
    CATCH_BLOCK,
    GLOBAL_STATEMENT,
    GLOBAL_VAR,
    STATIC_STATEMENT,
    STATIC_VAR,
    UNSET_VARIABLE_STATEMENT,
    UNSET_VARIABLES,
    ENUM_CASE,
    PRIMARY_EXPRESSION,
    MEMBER_EXPRESSION,
    NEW_OBJECT_EXPRESSION,
    NEW_OBJECT_CLASS_FIELD_ACCESS,
    SPECIAL_CALL,
    VARIABLE_WITHOUT_OBJECTS,
    CLASS_MEMBER_ACCESS,
    OBJECT_MEMBER_ACCESS,
    FUNCTION_CALL_PARAMETER_LIST,
    DIMENSIONAL_OFFSET,
    STATIC_SCALAR,
    ARRAY_INIALIZER,
    COMMON_SCALAR,
    YIELD_SCALAR,
    BOOLEAN_LITERAL,
    LEXICAL_VARIABLE,
    ASSIGNMENT_EXPRESSION,
    MULTIPLICATIVE_EXPR,
    POWER_EXPR,
    ADDITIVE_EXPR,
    SHIFT_EXPR,
    RELATIONAL_EXPR,
    EQUALITY_EXPR,
    POSTFIX_EXPR,
    UNARY_EXPR,
    ASSIGNMENT_BY_REFERENCE,
    ASSIGNMENT_OPERATOR,
    CAST_TYPE,
    INTERNAL_FUNCTION,
    ARRAY_PAIR_LIST,
    LIST_EXPRESSION_ASSIGNMENT,
    ARRAY_DESTRUCTURING_ASSIGNMENT,
    ARRAY_ASSIGNMENT_PATTERN_ELEMENT,
    COMPLEX_ENCAPS_VARIABLE,
    SEMI_COMPLEX_ENCAPS_VARIABLE,
    SEMI_COMPLEX_RECOVERY_EXPRESSION,
    SIMPLE_ENCAPS_VARIABLE,
    ENCAPS_VAR,
    EXIT_EXPRESSION,
    CALLABLE_CONVERT,
    NULL,
    CLASS_CONSTANT,
    FILE_CONSTANT,
    DIR_CONSTANT,
    FUNCTION_CONSTANT,
    LINE_CONSTANT,
    METHOD_CONSTANT,
    NAMESPACE_CONSTANT,
    TRAIT_CONSTANT,
    NEXT_IS_DOLLAR,
    DOUBLE_QUOTE,
    BACKTICK,
    REGULAR_STRING_LITERAL,
    VARIABLE_VARIABLE_DOLLAR,
    ENUM,
    ISSET,
    EMPTY,
    WHITESPACES,
    EXPRESSION,
    INCLUDE_ONCE,
    INCLUDE,
    EVAL,
    REQUIRE_ONCE,
    REQUIRE,
    CLONE,
    PRINT,
    GET,
    SET,
    SELF,
    PARENT,
    MIXED,
    INTEGER,
    INT,
    DOUBLE,
    FLOAT,
    REAL,
    STRING,
    OBJECT,
    BOOLEAN,
    BOOL,
    BINARY,
    ITERABLE,
    FROM,
    ATTRIBUTE,
    ATTRIBUTE_GROUP;


    public static LexerlessGrammar createGrammar() {
        return PHPLexicalGrammar.createGrammarBuilder().build();
    }

    public static LexerlessGrammarBuilder createGrammarBuilder() {
        LexerlessGrammarBuilder b = LexerlessGrammarBuilder.create();
        PHPLexicalGrammar.lexical(b);
        PHPLexicalGrammar.punctuators(b);
        PHPLexicalGrammar.keywords(b);
        return b;
    }

    public static void lexical(LexerlessGrammarBuilder b) {
        b.rule(SPACING).is(b.skippedTrivia(b.regexp("[\\n\\r\\u2028\\u2029\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]*+")), b.zeroOrMore(b.commentTrivia(b.regexp("(?://(?:(?!\\?>)[^\\n\\r])*+|#(?!\\[)(?:(?!\\?>)[^\\n\\r])*+|/\\*[\\s\\S]*?\\*/)")), b.skippedTrivia(b.regexp("[\\n\\r\\u2028\\u2029\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]*+")))).skip();
        b.rule(NOWDOC).is(SPACING, b.regexp("(?s)<<<[ \t\u000b\f]*+'([^\r\n'\"]++)'(?:\r\n?+|\n)(?:.*?(?:\r\n?+|\n))?[ \t]*+\\1(?![[a-zA-Z_\\x7f-\\xff][0-9]])"));
        b.rule(HEREDOC).is(SPACING, b.regexp("(?s)(<<<[ \t\u000b\f]*+\"?([^\r\n'\"]++)\"?(?:\r\n?+|\n))(?:(.*?)(?:\r\n?+|\n))?[ \t]*+\\2(?![[a-zA-Z_\\x7f-\\xff][0-9]])"));
        b.rule(NUMERIC_LITERAL).is(SPACING, b.regexp("(?:(?:[0-9]++(?:_[0-9]++)*+|(?:(?:[0-9]++(?:_[0-9]++)*+)*+[\\.][0-9]++(?:_[0-9]++)*+)|(?:[0-9]++(?:_[0-9]++)*+[\\.](?:[0-9]++(?:_[0-9]++)*+)*+))[eE][+-]?[0-9]++(?:_[0-9]++)*+)|(?:(?:[0-9]++(?:_[0-9]++)*+)*+[\\.][0-9]++(?:_[0-9]++)*+)|(?:[0-9]++(?:_[0-9]++)*+[\\.](?:[0-9]++(?:_[0-9]++)*+)*+)|0[xX][0-9a-fA-F]++(?:_[0-9a-fA-F]++)*+|0[bB][01]++(?:_[01]++)*+|0[oO]?[0-7]*+(?:_[0-7]++)*+|[1-9][0-9]*+(?:_[0-9]++)*+"));
        b.rule(REGULAR_STRING_LITERAL).is(SPACING, b.regexp("(?:\"(?:(?:(?:[^\"\\\\$\\{])|(?:\\$(?!\\{|[a-zA-Z_\\x7f-\\xff]))|(?:\\{(?!\\$))|(?:\\\\[\\s\\S]?))++)?+\"|'(?:[^'\\\\]*+(?:\\\\[\\s\\S])?+)*+')"));
        b.rule(STRING_WITH_ENCAPS_VAR_CHARACTERS).is(b.regexp("(?:(?:(?:[^\"\\\\$\\{])|(?:\\$(?!\\{|[a-zA-Z_\\x7f-\\xff]))|(?:\\{(?!\\$))|(?:\\\\[\\s\\S]?))++)"));
        b.rule(STRING_CHARACTERS_EXECUTION).is(b.regexp("(?:(?:(?:[^\\\\$\\{`])|(?:\\$(?!\\{|[a-zA-Z_\\x7f-\\xff]))|(?:\\{(?!\\$))|(?:\\\\[\\s\\S]?))++)"));
        b.rule(HEREDOC_STRING_CHARACTERS).is(b.regexp("(?:(?:(?:[^\\\\$\\{])|(?:\\$(?!\\{|[a-zA-Z_\\x7f-\\xff]))|(?:\\{(?!\\$))|(?:\\\\[\\s\\S]?))++)"));
        b.rule(DOUBLE_QUOTE).is("\"");
        b.rule(BACKTICK).is("`");
        b.rule(SEMI_COMPLEX_RECOVERY_EXPRESSION).is(b.regexp("[^}]++"));
        b.rule(ASYMMETRIC_VISIBILITY_MODIFIER).is(SPACING, b.regexp("(?i)(?:public|protected|private)\\(set\\)"));
        b.rule(WHITESPACES).is(b.regexp("[\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]*+"));
        b.rule(REGULAR_VAR_IDENTIFIER).is(SPACING, VARIABLE_IDENTIFIER).skip();
        b.rule(VARIABLE_IDENTIFIER).is(b.regexp("\\$[a-zA-Z_\\x7f-\\xff][[a-zA-Z_\\x7f-\\xff][0-9]]*+"));
        b.rule(IDENTIFIER).is(SPACING, b.firstOf(b.sequence(b.nextNot(KEYWORDS), b.regexp("[a-zA-Z_\\x7f-\\xff][[a-zA-Z_\\x7f-\\xff][0-9]]*+")), b.regexp("(?i)match")));
        b.rule(IDENTIFIER_OR_KEYWORD).is(SPACING, b.regexp("[a-zA-Z_\\x7f-\\xff][[a-zA-Z_\\x7f-\\xff][0-9]]*+"));
        b.rule(NS_SEPARATOR_WITHOUT_SPACE).is(b.regexp("\\\\"));
        b.rule(FILE_OPENING_TAG).is(SPACING, b.regexp("(?:(?!(?i)<\\?(?:php|=|))[\\s\\S])*+(?:(?i)<\\?(?:php|=|))")).skip();
        b.rule(INLINE_HTML).is(SPACING, b.regexp("\\?>(?:(?!(?i)<\\?(?:php|=|))[\\s\\S])*+(?:(?i)<\\?(?:php|=|))?+")).skip();
        b.rule(ANYTHING_BUT_START_TAG).is(SPACING, b.regexp("(?:(?!(?i)<\\?(?:php|=|))[\\s\\S])++")).skip();
        b.rule(EOF).is(b.token(GenericTokenType.EOF, b.endOfInput())).skip();
        b.rule(NULL).is(PHPLexicalGrammar.word(b, "NULL")).skip();
        b.rule(CLASS_CONSTANT).is(PHPLexicalGrammar.word(b, "__CLASS__")).skip();
        b.rule(FILE_CONSTANT).is(PHPLexicalGrammar.word(b, "__FILE__")).skip();
        b.rule(DIR_CONSTANT).is(PHPLexicalGrammar.word(b, "__DIR__")).skip();
        b.rule(FUNCTION_CONSTANT).is(PHPLexicalGrammar.word(b, "__FUNCTION__")).skip();
        b.rule(LINE_CONSTANT).is(PHPLexicalGrammar.word(b, "__LINE__")).skip();
        b.rule(METHOD_CONSTANT).is(PHPLexicalGrammar.word(b, "__METHOD__")).skip();
        b.rule(NAMESPACE_CONSTANT).is(PHPLexicalGrammar.word(b, "__NAMESPACE__")).skip();
        b.rule(TRAIT_CONSTANT).is(PHPLexicalGrammar.word(b, "__TRAIT__")).skip();
        b.rule(ENUM).is(PHPLexicalGrammar.word(b, "enum")).skip();
        b.rule(BOOLEAN_LITERAL).is(b.firstOf(PHPLexicalGrammar.word(b, "TRUE"), PHPLexicalGrammar.word(b, "FALSE")));
        b.rule(NEXT_IS_DOLLAR).is(b.next(PHPPunctuator.DOLLAR));
        b.rule(VARIABLE_VARIABLE_DOLLAR).is(PHPPunctuator.DOLLAR, b.nextNot(b.firstOf(IDENTIFIER, KEYWORDS, PHPPunctuator.LCURLYBRACE)));
        b.rule(ISSET).is(PHPLexicalGrammar.word(b, "ISSET")).skip();
        b.rule(EMPTY).is(PHPLexicalGrammar.word(b, "EMPTY")).skip();
        b.rule(INCLUDE_ONCE).is(PHPLexicalGrammar.word(b, "INCLUDE_ONCE")).skip();
        b.rule(INCLUDE).is(PHPLexicalGrammar.word(b, "INCLUDE")).skip();
        b.rule(EVAL).is(PHPLexicalGrammar.word(b, "EVAL")).skip();
        b.rule(REQUIRE_ONCE).is(PHPLexicalGrammar.word(b, "REQUIRE_ONCE")).skip();
        b.rule(REQUIRE).is(PHPLexicalGrammar.word(b, "REQUIRE")).skip();
        b.rule(CLONE).is(PHPLexicalGrammar.word(b, "CLONE")).skip();
        b.rule(PRINT).is(PHPLexicalGrammar.word(b, "PRINT")).skip();
        b.rule(GET).is(PHPLexicalGrammar.word(b, "GET")).skip();
        b.rule(SET).is(PHPLexicalGrammar.word(b, "SET")).skip();
        b.rule(SELF).is(PHPLexicalGrammar.word(b, "SELF")).skip();
        b.rule(PARENT).is(PHPLexicalGrammar.word(b, "PARENT")).skip();
        b.rule(MIXED).is(PHPLexicalGrammar.word(b, "MIXED")).skip();
        b.rule(INTEGER).is(PHPLexicalGrammar.word(b, "INTEGER")).skip();
        b.rule(INT).is(PHPLexicalGrammar.word(b, "INT")).skip();
        b.rule(DOUBLE).is(PHPLexicalGrammar.word(b, "DOUBLE")).skip();
        b.rule(FLOAT).is(PHPLexicalGrammar.word(b, "FLOAT")).skip();
        b.rule(REAL).is(PHPLexicalGrammar.word(b, "REAL")).skip();
        b.rule(STRING).is(PHPLexicalGrammar.word(b, "STRING")).skip();
        b.rule(OBJECT).is(PHPLexicalGrammar.word(b, "OBJECT")).skip();
        b.rule(BOOLEAN).is(PHPLexicalGrammar.word(b, "BOOLEAN")).skip();
        b.rule(BOOL).is(PHPLexicalGrammar.word(b, "BOOL")).skip();
        b.rule(BINARY).is(PHPLexicalGrammar.word(b, "BINARY")).skip();
        b.rule(ITERABLE).is(PHPLexicalGrammar.word(b, "ITERABLE")).skip();
        b.rule(FROM).is(PHPLexicalGrammar.word(b, "FROM")).skip();
    }

    private static void keywords(LexerlessGrammarBuilder b) {
        Object[] rest = new Object[PHPKeyword.values().length - 2];
        for (int i = 0; i < PHPKeyword.values().length; ++i) {
            PHPKeyword tokenType = PHPKeyword.values()[i];
            b.rule(tokenType).is(SPACING, PHPLexicalGrammar.keywordRegexp(b, tokenType.getValue()), b.nextNot(b.regexp("[[a-zA-Z_\\x7f-\\xff][0-9]]"))).skip();
            if (i <= 1) continue;
            rest[i - 2] = tokenType == PHPKeyword.READONLY ? b.sequence(PHPLexicalGrammar.keywordRegexp(b, "readonly"), b.nextNot(b.regexp("[\\s]*\\("))) : PHPLexicalGrammar.keywordRegexp(b, tokenType.getValue());
        }
        b.rule(KEYWORDS).is(SPACING, b.firstOf(PHPLexicalGrammar.keywordRegexp(b, PHPKeyword.getKeywordValues()[0]), PHPLexicalGrammar.keywordRegexp(b, PHPKeyword.getKeywordValues()[1]), rest), b.nextNot(b.regexp("[[a-zA-Z_\\x7f-\\xff][0-9]]")));
    }

    private static void punctuators(LexerlessGrammarBuilder b) {
        for (PHPPunctuator p : PHPPunctuator.values()) {
            b.rule(p).is(SPACING, p.getValue()).skip();
        }
    }

    private static Object word(LexerlessGrammarBuilder b, String word) {
        return b.sequence(SPACING, b.regexp("(?i)" + word), b.nextNot(b.regexp("[[a-zA-Z_\\x7f-\\xff][0-9]]")));
    }

    private static Object keywordRegexp(LexerlessGrammarBuilder b, String keywordValue) {
        return b.regexp("(?i)" + keywordValue);
    }
}

