/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.impl.statement;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.php.utils.collections.IteratorUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.statement.ElseifClauseTree;
import org.sonar.plugins.php.api.tree.statement.StatementTree;
import org.sonar.plugins.php.api.visitors.VisitorCheck;

public class ElseifClauseTreeImpl
extends PHPTree
implements ElseifClauseTree {
    private final Tree.Kind kind;
    private final InternalSyntaxToken elseifToken;
    private final ParenthesisedExpressionTree condition;
    private final InternalSyntaxToken colonToken;
    private final List<StatementTree> statements;

    public ElseifClauseTreeImpl(InternalSyntaxToken elseifToken, ParenthesisedExpressionTree condition, StatementTree statement) {
        this.kind = Tree.Kind.ELSEIF_CLAUSE;
        this.elseifToken = elseifToken;
        this.condition = condition;
        this.statements = Collections.singletonList(statement);
        this.colonToken = null;
    }

    public ElseifClauseTreeImpl(InternalSyntaxToken elseifToken, ParenthesisedExpressionTree condition, InternalSyntaxToken colonToken, List<StatementTree> statements) {
        this.kind = Tree.Kind.ALTERNATIVE_ELSEIF_CLAUSE;
        this.elseifToken = elseifToken;
        this.condition = condition;
        this.statements = statements;
        this.colonToken = colonToken;
    }

    @Override
    public SyntaxToken elseifToken() {
        return this.elseifToken;
    }

    @Override
    public ParenthesisedExpressionTree condition() {
        return this.condition;
    }

    @Override
    @Nullable
    public SyntaxToken colonToken() {
        return this.colonToken;
    }

    @Override
    public List<StatementTree> statements() {
        return this.statements;
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return IteratorUtils.concat(IteratorUtils.iteratorOf(this.elseifToken, this.condition, this.colonToken), this.statements.iterator());
    }

    @Override
    public void accept(VisitorCheck visitor) {
        visitor.visitElseifClause(this);
    }
}

