/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.impl.statement;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.php.utils.collections.IteratorUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.php.api.tree.statement.ElseifClauseTree;
import org.sonar.plugins.php.api.tree.statement.IfStatementTree;
import org.sonar.plugins.php.api.tree.statement.StatementTree;
import org.sonar.plugins.php.api.visitors.VisitorCheck;

public class IfStatementTreeImpl
extends PHPTree
implements IfStatementTree {
    private final Tree.Kind kind;
    private final InternalSyntaxToken ifToken;
    private final ParenthesisedExpressionTree condition;
    private final InternalSyntaxToken colonToken;
    private final List<StatementTree> statements;
    private final List<ElseifClauseTree> elseifClauses;
    private final ElseClauseTree elseClause;
    private final InternalSyntaxToken endifToken;
    private final InternalSyntaxToken eosToken;

    public IfStatementTreeImpl(InternalSyntaxToken ifToken, ParenthesisedExpressionTree condition, StatementTree statement, List<ElseifClauseTree> elseifClauses, ElseClauseTree elseClause) {
        this.kind = Tree.Kind.IF_STATEMENT;
        this.ifToken = ifToken;
        this.condition = condition;
        this.statements = Collections.singletonList(statement);
        this.elseifClauses = elseifClauses;
        this.elseClause = elseClause;
        this.colonToken = null;
        this.endifToken = null;
        this.eosToken = null;
    }

    public IfStatementTreeImpl(InternalSyntaxToken ifToken, ParenthesisedExpressionTree condition, InternalSyntaxToken colonToken, List<StatementTree> statements, List<ElseifClauseTree> elseifClauses, ElseClauseTree elseClause, InternalSyntaxToken endifToken, InternalSyntaxToken eosToken) {
        this.kind = Tree.Kind.ALTERNATIVE_IF_STATEMENT;
        this.ifToken = ifToken;
        this.condition = condition;
        this.statements = statements;
        this.elseifClauses = elseifClauses;
        this.elseClause = elseClause;
        this.colonToken = colonToken;
        this.endifToken = endifToken;
        this.eosToken = eosToken;
    }

    @Override
    public SyntaxToken ifToken() {
        return this.ifToken;
    }

    @Override
    public ParenthesisedExpressionTree condition() {
        return this.condition;
    }

    @Override
    @Nullable
    public SyntaxToken colonToken() {
        return this.colonToken;
    }

    @Override
    public List<StatementTree> statements() {
        return this.statements;
    }

    @Override
    public List<ElseifClauseTree> elseifClauses() {
        return this.elseifClauses;
    }

    @Override
    @Nullable
    public ElseClauseTree elseClause() {
        return this.elseClause;
    }

    @Override
    @Nullable
    public SyntaxToken endifToken() {
        return this.endifToken;
    }

    @Override
    @Nullable
    public SyntaxToken eosToken() {
        return this.eosToken;
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return IteratorUtils.concat(IteratorUtils.iteratorOf(this.ifToken, this.condition, this.colonToken), this.statements.iterator(), this.elseifClauses.iterator(), IteratorUtils.iteratorOf(this.elseClause, this.endifToken, this.eosToken));
    }

    @Override
    public void accept(VisitorCheck visitor) {
        visitor.visitIfStatement(this);
    }
}

