/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.utils.collections;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

public class IteratorUtils {
    private IteratorUtils() {
    }

    public static <T> Iterator<T> iteratorOf(T element) {
        return Collections.singletonList(element).iterator();
    }

    @SafeVarargs
    public static <T> Iterator<T> iteratorOf(T ... element) {
        return Arrays.asList(element).iterator();
    }

    public static <T> Iterator<T> nullableIterator(@Nullable T element) {
        if (element == null) {
            return Collections.emptyIterator();
        }
        return IteratorUtils.iteratorOf(element);
    }

    @SafeVarargs
    public static <T> Iterator<T> concat(Iterator<? extends T> ... iterators) {
        return new IteratorIterator<T>(iterators);
    }

    private static class IteratorIterator<T>
    implements Iterator<T> {
        private final Iterator<? extends T>[] iterables;
        private Iterator<? extends T> current;
        private int currentIndex;

        @SafeVarargs
        public IteratorIterator(Iterator<? extends T> ... iterables) {
            this.iterables = iterables;
        }

        @Override
        public boolean hasNext() {
            this.checkNext();
            return this.current != null && this.current.hasNext();
        }

        @Override
        public T next() {
            this.checkNext();
            if (this.current == null || !this.current.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.current.next();
        }

        private void checkNext() {
            while (!(this.current != null && this.current.hasNext() || this.currentIndex >= this.iterables.length)) {
                this.current = this.iterables[this.currentIndex];
                ++this.currentIndex;
            }
        }
    }
}

