/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.sonar.api.server.profile.BuiltInQualityProfilesDefinition;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class XmlProfileParser {
    private XmlProfileParser() {
    }

    static void parse(String path, BuiltInQualityProfilesDefinition.NewBuiltInQualityProfile profile) {
        try {
            String content = XmlProfileParser.toString(path);
            XmlFile xmlFile = XmlFile.create(content);
            NodeList ruleNodeList = xmlFile.getDocument().getElementsByTagName("rule");
            XmlFile.asList(ruleNodeList).forEach(ruleNode -> {
                Element ruleElement = (Element)ruleNode;
                String repositoryKey = XmlProfileParser.getChildContent(ruleElement, "repositoryKey");
                String key = XmlProfileParser.getChildContent(ruleElement, "key");
                BuiltInQualityProfilesDefinition.NewBuiltInActiveRule newActiveRule = profile.activateRule(repositoryKey, key);
                NodeList parameterNodeList = ruleElement.getElementsByTagName("parameter");
                XmlFile.asList(parameterNodeList).forEach(parameter -> {
                    Element parameterElement = (Element)parameter;
                    String paramKey = XmlProfileParser.getChildContent(parameterElement, "key");
                    String paramValue = XmlProfileParser.getChildContent(parameterElement, "value");
                    newActiveRule.overrideParam(paramKey, paramValue);
                });
                Optional<String> priority = XmlProfileParser.getOptionalChildContent(ruleElement, "priority");
                priority.ifPresent(newActiveRule::overrideSeverity);
            });
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create profile", e);
        }
    }

    private static String getChildContent(Element element, String tagName) {
        Optional<String> optionalChildContent = XmlProfileParser.getOptionalChildContent(element, tagName);
        return optionalChildContent.orElseThrow(() -> new IllegalStateException("Failed to get content of " + tagName));
    }

    private static Optional<String> getOptionalChildContent(Element element, String tagName) {
        NodeList elementsByTagName = element.getElementsByTagName(tagName);
        if (elementsByTagName.getLength() > 0) {
            Node child = elementsByTagName.item(0);
            return Optional.of(child.getTextContent());
        }
        return Optional.empty();
    }

    private static String toString(String path) throws IOException {
        try (InputStream input = XmlProfileParser.class.getClassLoader().getResourceAsStream(path);){
            if (input == null) {
                throw new IOException("Resource not found in the classpath: " + path);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int read = input.read(buffer);
            while (read != -1) {
                out.write(buffer, 0, read);
                read = input.read(buffer);
            }
            String string = new String(out.toByteArray(), StandardCharsets.UTF_8);
            return string;
        }
    }
}

