/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.reports.phpunit.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.plugins.php.reports.phpunit.TestFileReport;
import org.sonar.plugins.php.reports.phpunit.xml.TestCase;

public final class TestSuite {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestSuite.class);
    private String name;
    private String file;
    private double time;
    private List<TestSuite> testSuites = new ArrayList<TestSuite>();
    List<TestCase> testCases;

    public TestSuite(@Nullable String name, @Nullable String file, double time, List<TestCase> testCases) {
        this.name = name;
        this.file = file;
        this.time = time;
        this.testCases = testCases;
    }

    public TestSuite(String file) {
        this(null, file, 0.0, Collections.emptyList());
    }

    public Collection<TestFileReport> generateReports() {
        return this.collectAllFileBasedSuites().stream().map(TestSuite::createReport).collect(Collectors.toSet());
    }

    private Collection<TestSuite> collectAllFileBasedSuites() {
        HashSet<TestSuite> fileBasedTestSuites = new HashSet<TestSuite>();
        if (this.isFileBased()) {
            fileBasedTestSuites.add(this);
        } else {
            this.logMisplacedTestCases();
        }
        this.testSuites.forEach(childSuite -> fileBasedTestSuites.addAll(childSuite.collectAllFileBasedSuites()));
        return fileBasedTestSuites;
    }

    private void logMisplacedTestCases() {
        this.testCases.forEach(testCase -> LOGGER.warn("Test cases must always be descendants of a file-based suite, skipping : {} in {}", (Object)testCase.fullName(), (Object)this.name));
    }

    private boolean isFileBased() {
        return this.file != null;
    }

    private TestFileReport createReport() {
        TestFileReport report = new TestFileReport(this.file, this.time);
        this.collectTestCases(report);
        return report;
    }

    private void collectTestCases(TestFileReport fileReport) {
        this.testCases.forEach(fileReport::addTestCase);
        this.testSuites.forEach(childSuite -> childSuite.collectTestCases(fileReport));
    }

    public void addNested(TestSuite child) {
        this.testSuites.add(child);
    }
}

