/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.checks.verifier.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.sonarsource.analyzer.commons.checks.verifier.internal.Comment;
import org.sonarsource.analyzer.commons.checks.verifier.internal.LineIssues;
import org.sonarsource.analyzer.commons.checks.verifier.quickfix.QuickFix;
import org.sonarsource.analyzer.commons.checks.verifier.quickfix.TextEdit;
import org.sonarsource.analyzer.commons.checks.verifier.quickfix.TextSpan;

public class QuickFixParser {
    private static final Pattern QUICK_FIX_MESSAGE = Pattern.compile("\\s*fix@(?<id>\\S++)\\s++\\{\\{(?<message>.*)\\}\\}");
    private static final Pattern QUICK_FIX_EDIT = Pattern.compile("\\s*edit@(?<id>\\S+).++");
    private static final String PROPS_START_DELIMITER = "[[";
    private static final String PROPS_END_DELIMITER = "]]";
    private final Map<String, QuickFix> expectedQuickFixes = new HashMap<String, QuickFix>();
    private final Map<TextSpan, List<String>> quickFixesForIssue = new HashMap<TextSpan, List<String>>();
    private final Map<String, String> quickfixesMessages = new HashMap<String, String>();
    private final Map<String, List<RelativeTextEdit>> quickfixesEdits = new HashMap<String, List<RelativeTextEdit>>();
    private final Map<String, Integer> quickfixesLineReference = new HashMap<String, Integer>();

    public QuickFixParser(List<Comment> expectedQuickFixesComments, Map<Integer, LineIssues> expectedIssues) {
        this.buildExpectedQuickFixes(expectedQuickFixesComments, expectedIssues);
    }

    private void buildExpectedQuickFixes(List<Comment> expectedQuickFixesComments, Map<Integer, LineIssues> expectedIssues) {
        this.populateIssueData(expectedIssues);
        for (Comment comment : expectedQuickFixesComments) {
            this.parseQuickFix(comment.content, comment.line);
        }
        for (Map.Entry entry : this.quickFixesForIssue.entrySet()) {
            for (String qfId : (List)entry.getValue()) {
                List<RelativeTextEdit> edits = this.quickfixesEdits.get(qfId);
                if (edits == null) {
                    throw new AssertionError((Object)String.format("[Quick Fix] Quick fix edits not found for quick fix id %s", qfId));
                }
                String description = this.quickfixesMessages.get(qfId);
                if (description == null) {
                    throw new AssertionError((Object)String.format("[Quick Fix] Quick fix description not found for quick fix id %s", qfId));
                }
                QuickFix quickFix = QuickFix.newQuickFix(description, entry.getKey()).addTextEdits(edits.stream().map(rel -> rel.toAbsoluteTextEdit(this.quickfixesLineReference.get(qfId))).collect(Collectors.toList())).build();
                this.expectedQuickFixes.put(qfId, quickFix);
            }
        }
    }

    private void populateIssueData(Map<Integer, LineIssues> expectedIssues) {
        expectedIssues.values().forEach(lineIssues -> {
            String qfIds = lineIssues.params.get("quickfixes");
            if (qfIds != null && !"!".equals(qfIds)) {
                String[] ids;
                for (String id : ids = qfIds.split(",")) {
                    this.quickfixesLineReference.put(id, lineIssues.line);
                    this.quickFixesForIssue.computeIfAbsent(QuickFixParser.getTextSpan(lineIssues), k -> new ArrayList()).add(id);
                }
            }
        });
    }

    void parseQuickFix(String comment, int line) {
        Matcher messageMatcher = QUICK_FIX_MESSAGE.matcher(comment);
        if (messageMatcher.find()) {
            String quickFixId = messageMatcher.group("id");
            String quickFixMessage = messageMatcher.group("message");
            this.quickfixesMessages.put(quickFixId, quickFixMessage);
            return;
        }
        Matcher editMatcher = QUICK_FIX_EDIT.matcher(comment);
        if (editMatcher.find()) {
            String quickFixId = editMatcher.group("id");
            String replacement = QuickFixParser.parseMessage(comment, comment.length());
            if (replacement == null) {
                throw new AssertionError((Object)String.format("[Quick Fix] Missing replacement for edit at line %d", line));
            }
            RelativeTextEdit relativeTextEdit = QuickFixParser.parseTextEdit(comment, replacement);
            this.quickfixesEdits.computeIfAbsent(quickFixId, k -> new ArrayList()).add(relativeTextEdit);
        }
    }

    private static String parseMessage(String cleanedComment, int horizon) {
        String delimitedComment = cleanedComment.substring(0, horizon);
        int firstIndex = delimitedComment.indexOf("{{");
        if (firstIndex != -1) {
            int lastIndex = delimitedComment.lastIndexOf("}}");
            if (lastIndex != -1) {
                return delimitedComment.substring(firstIndex + 2, lastIndex);
            }
            throw new AssertionError((Object)String.format("[Quick Fix] Wrong format in comment: %s", cleanedComment));
        }
        return null;
    }

    private static RelativeTextEdit parseTextEdit(String comment, String replacement) {
        RelativeTextEdit relativeTextEdit = new RelativeTextEdit();
        relativeTextEdit.replacement = replacement;
        int start = comment.indexOf(PROPS_START_DELIMITER);
        int end = comment.indexOf(PROPS_END_DELIMITER);
        if (start != -1 && end != -1) {
            String[] attributes;
            String qfPropertiesString = comment.substring(start + PROPS_START_DELIMITER.length(), end);
            block12: for (String attr : attributes = qfPropertiesString.split(";")) {
                String[] keyValue = attr.split("=");
                switch (keyValue[0]) {
                    case "sl": {
                        relativeTextEdit.sl = new RelativeTextEdit.RelativeLine(keyValue[1]);
                        continue block12;
                    }
                    case "sc": {
                        relativeTextEdit.sc = Integer.parseInt(keyValue[1]);
                        continue block12;
                    }
                    case "el": {
                        relativeTextEdit.el = new RelativeTextEdit.RelativeLine(keyValue[1]);
                        continue block12;
                    }
                    case "ec": {
                        relativeTextEdit.ec = Integer.parseInt(keyValue[1]);
                        continue block12;
                    }
                    default: {
                        throw new AssertionError((Object)String.format("[Quick Fix] Invalid quickfix edit format: %s", comment));
                    }
                }
            }
            return relativeTextEdit;
        }
        throw new AssertionError((Object)String.format("[Quick Fix] Invalid quickfix edit format: %s", comment));
    }

    private static TextSpan getTextSpan(LineIssues issue) {
        String sc = issue.params.get("sc");
        String ec = issue.params.get("ec");
        return new TextSpan(issue.line, sc != null ? Integer.parseInt(sc) : 1, issue.line, ec != null ? Integer.parseInt(ec) : 1);
    }

    public Map<String, QuickFix> getExpectedQuickFixes() {
        return this.expectedQuickFixes;
    }

    private static class RelativeTextEdit {
        private RelativeLine sl = new RelativeLine();
        private int sc = 0;
        private RelativeLine el = new RelativeLine();
        private int ec = 0;
        private String replacement = "";

        private RelativeTextEdit() {
        }

        public TextEdit toAbsoluteTextEdit(int referenceLine) {
            int startLine = this.sl.isRelative ? referenceLine + this.sl.line : this.sl.line;
            int endLine = this.el.isRelative ? referenceLine + this.el.line : this.el.line;
            return TextEdit.replaceTextSpan(new TextSpan(startLine, this.sc, endLine, this.ec), this.replacement);
        }

        private static class RelativeLine {
            private int line = 0;
            private boolean isRelative = true;

            public RelativeLine() {
            }

            public RelativeLine(String line) {
                this.line = Integer.parseInt(line);
                if (!line.startsWith("+") && !line.startsWith("-")) {
                    this.isRelative = false;
                }
            }
        }
    }
}

