/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.checks.verifier.internal;

import java.util.ArrayList;
import java.util.List;
import org.sonarsource.analyzer.commons.checks.verifier.FileContent;
import org.sonarsource.analyzer.commons.checks.verifier.internal.Comment;

public class SingleLineCommentParser
implements Comment.Parser {
    public final String commentPrefix;

    public SingleLineCommentParser(String commentPrefix) {
        this.commentPrefix = commentPrefix;
    }

    @Override
    public List<Comment> parse(FileContent file) {
        ArrayList<Comment> comments = new ArrayList<Comment>();
        String[] lines = file.getContent().split("\r?\n|\r", -1);
        for (int lineIndex = 0; lineIndex < lines.length; ++lineIndex) {
            String line = lines[lineIndex];
            int commentIndex = line.indexOf(this.commentPrefix);
            if (commentIndex == -1) continue;
            int lineNumber = lineIndex + 1;
            int column = commentIndex + 1;
            int contentColumn = column + this.commentPrefix.length();
            String commentContent = line.substring(contentColumn - 1);
            comments.add(new Comment(file.getPath(), lineNumber, column, contentColumn, commentContent));
        }
        return comments;
    }
}

