/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.sonarsource.analyzer.commons.xml.ParseException;
import org.sonarsource.analyzer.commons.xml.PrologElement;
import org.sonarsource.analyzer.commons.xml.SafeDomParserFactory;
import org.sonarsource.analyzer.commons.xml.SafeStaxParserFactory;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.sonarsource.analyzer.commons.xml.XmlFilePosition;
import org.sonarsource.analyzer.commons.xml.XmlTextRange;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

class XmlParser {
    private static final String BOM_CHAR = "\ufeff";
    private static final String XML_DECLARATION_TAG = "<?xml";
    private XmlFilePosition xmlFileStartLocation;
    private XmlFilePosition currentNodeStartLocation = null;
    private XmlTextRange currentNodeStartRange = null;
    private String content;
    private Node currentNode;
    private boolean currentNodeIsClosed = false;
    private boolean previousEventIsText = false;
    private Deque<Node> nodes = new LinkedList<Node>();
    private XmlFile xmlFile;

    XmlParser(XmlFile xmlFile, boolean namespaceAware) {
        this.xmlFile = xmlFile;
        try {
            this.setContent();
            ByteArrayInputStream stream = new ByteArrayInputStream(this.content.getBytes(xmlFile.getCharset()));
            Document document = SafeDomParserFactory.createDocumentBuilder(namespaceAware).parse(stream);
            xmlFile.setDocument(document, namespaceAware);
            this.currentNode = document;
            this.nodes.push(this.currentNode);
            this.parseXmlDeclaration();
            this.parseXml();
            XmlParser.setDocumentLocation(xmlFile);
        }
        catch (IOException | XMLStreamException | SAXException e) {
            throw new ParseException(e);
        }
    }

    private static void setDocumentLocation(XmlFile xmlFile) {
        Document document = xmlFile.getDocument();
        XmlTextRange startRange = XmlFile.nodeLocation(document.getFirstChild());
        XmlTextRange end = XmlFile.nodeLocation(document.getLastChild());
        Optional<PrologElement> prologElement = xmlFile.getPrologElement();
        if (prologElement.isPresent()) {
            startRange = prologElement.get().getPrologStartLocation();
        }
        document.setUserData(XmlFile.Location.NODE.name(), new XmlTextRange(startRange, end), null);
    }

    private void setContent() throws XMLStreamException {
        int realStartIndex;
        String fullContent = this.xmlFile.getContents();
        if (fullContent.startsWith(BOM_CHAR)) {
            fullContent = fullContent.substring(1);
        }
        if ((realStartIndex = fullContent.indexOf(XML_DECLARATION_TAG)) == -1) {
            this.xmlFileStartLocation = new XmlFilePosition(fullContent);
            this.content = fullContent;
        } else {
            this.content = fullContent.substring(realStartIndex);
            this.xmlFileStartLocation = new XmlFilePosition(fullContent).moveBefore(XML_DECLARATION_TAG);
        }
    }

    private void parseXml() throws XMLStreamException {
        XMLStreamReader xmlReader = SafeStaxParserFactory.createXMLInputFactory().createXMLStreamReader(new StringReader(this.content));
        boolean emptyCdata = false;
        while (xmlReader.hasNext()) {
            this.previousEventIsText = emptyCdata && this.previousEventIsText || xmlReader.getEventType() == 4;
            emptyCdata = false;
            xmlReader.next();
            XmlFilePosition startLocation = new XmlFilePosition(this.content, xmlReader.getLocation());
            this.finalizePreviousNode(startLocation);
            switch (xmlReader.getEventType()) {
                case 3: 
                case 5: 
                case 9: {
                    this.setNextNode();
                    this.currentNodeStartLocation = startLocation;
                    break;
                }
                case 4: {
                    this.visitTextNode(startLocation);
                    break;
                }
                case 1: {
                    this.visitStartElement(xmlReader, startLocation);
                    break;
                }
                case 2: {
                    this.visitEndElement(startLocation);
                    break;
                }
                case 12: {
                    if (xmlReader.getText().isEmpty()) {
                        emptyCdata = true;
                        break;
                    }
                    this.visitCdata(startLocation);
                    break;
                }
                case 11: {
                    this.visitDTD(startLocation);
                    break;
                }
            }
            if (xmlReader.getEventType() == 1 || xmlReader.getEventType() == 2 || emptyCdata) continue;
            this.currentNodeIsClosed = true;
        }
    }

    private void visitTextNode(XmlFilePosition startLocation) {
        if (this.previousEventIsText) {
            this.currentNodeStartRange = XmlFile.nodeLocation(this.currentNode);
        } else {
            this.setNextNode();
            this.currentNodeStartLocation = startLocation;
        }
    }

    private void finalizePreviousNode(XmlFilePosition endLocation) {
        if (this.currentNodeStartLocation != null) {
            this.setLocation(this.currentNode, XmlFile.Location.NODE, this.currentNodeStartLocation, endLocation);
            if (this.currentNode.getFirstChild() != null) {
                this.setLocation(this.currentNode.getFirstChild(), XmlFile.Location.NODE, this.currentNodeStartLocation, endLocation);
            }
        } else if (this.currentNodeStartRange != null) {
            this.currentNode.setUserData(XmlFile.Location.NODE.name(), new XmlTextRange(this.currentNodeStartRange, endLocation, this.xmlFileStartLocation), null);
        }
        this.currentNodeStartLocation = null;
        this.currentNodeStartRange = null;
    }

    private void visitStartElement(XMLStreamReader xmlReader, XmlFilePosition startLocation) throws XMLStreamException {
        this.setNextNode();
        this.nodes.push(this.currentNode);
        XmlFilePosition nameEndLocation = startLocation.shift(XmlParser.getNameWithNamespaceLength(xmlReader) + 1);
        XmlFilePosition closingBracketEndLocation = startLocation.moveAfterClosingBracket();
        this.setLocation(this.currentNode, XmlFile.Location.START, startLocation, closingBracketEndLocation);
        this.setLocation(this.currentNode, XmlFile.Location.NAME, startLocation.shift(1), nameEndLocation);
        this.visitAttributes(nameEndLocation, closingBracketEndLocation.moveBackward());
    }

    private void visitEndElement(XmlFilePosition startLocation) throws XMLStreamException {
        this.currentNode = this.nodes.pop();
        XmlFilePosition closingBracketEndLocation = startLocation.moveAfterClosingBracket();
        this.setLocation(this.currentNode, XmlFile.Location.END, startLocation, closingBracketEndLocation);
        XmlTextRange startRange = (XmlTextRange)this.currentNode.getUserData(XmlFile.Location.START.name());
        this.currentNode.setUserData(XmlFile.Location.NODE.name(), new XmlTextRange(startRange, closingBracketEndLocation, this.xmlFileStartLocation), null);
        this.currentNodeIsClosed = true;
    }

    private void setNextNode() {
        this.currentNode = this.currentNodeIsClosed ? this.currentNode.getNextSibling() : this.currentNode.getFirstChild();
        this.currentNodeIsClosed = false;
    }

    private void parseXmlDeclaration() throws XMLStreamException {
        XmlFilePosition startLocation = new XmlFilePosition(this.content);
        if (startLocation.startsWith(XML_DECLARATION_TAG)) {
            XmlFilePosition endLocation = startLocation.moveAfterClosingBracket();
            XmlFilePosition attributesStart = startLocation.moveAfter(XML_DECLARATION_TAG);
            List<PrologElement.PrologAttribute> prologAttributes = this.visitPrologAttributes(attributesStart, endLocation.moveBackward());
            this.xmlFile.setPrologElement(new PrologElement(prologAttributes, new XmlTextRange(startLocation, attributesStart, this.xmlFileStartLocation), new XmlTextRange(endLocation.moveBackward().moveBackward(), endLocation, this.xmlFileStartLocation)));
        }
    }

    private void visitDTD(XmlFilePosition startLocation) throws XMLStreamException {
        this.setNextNode();
        XmlFilePosition endLocation = startLocation.moveAfterClosingBracket();
        this.setLocation(this.currentNode, XmlFile.Location.NODE, startLocation, endLocation);
    }

    private void visitCdata(XmlFilePosition startLocation) throws XMLStreamException {
        if (!startLocation.startsWith("<![CDATA[")) {
            return;
        }
        this.setNextNode();
        XmlFilePosition beforeClosingTag = startLocation.moveBefore("]]>");
        XmlFilePosition endLocation = beforeClosingTag.moveAfter("]]>");
        this.setLocation(this.currentNode, XmlFile.Location.START, startLocation, startLocation.moveAfter("<![CDATA["));
        this.setLocation(this.currentNode, XmlFile.Location.END, beforeClosingTag, endLocation);
        this.setLocation(this.currentNode, XmlFile.Location.NODE, startLocation, endLocation);
    }

    private void setLocation(Node node, XmlFile.Location locationKind, XmlFilePosition start, XmlFilePosition end) {
        node.setUserData(locationKind.name(), new XmlTextRange(start, end, this.xmlFileStartLocation), null);
    }

    private void visitAttributes(XmlFilePosition start, XmlFilePosition end) throws XMLStreamException {
        NamedNodeMap attributes = this.currentNode.getAttributes();
        XmlFilePosition currentLocation = start.moveAfterWhitespaces();
        while (currentLocation.has("=", end)) {
            XmlFilePosition attributeNameEnd = currentLocation.moveBefore("=");
            XmlFilePosition attributeValueStart = attributeNameEnd.moveAfter("=").moveAfterWhitespaces();
            char c = attributeValueStart.readChar();
            XmlFilePosition attributeValueEnd = attributeValueStart.shift(1).moveAfter(String.valueOf(c));
            String attributeName = currentLocation.textUntil(attributeNameEnd).trim();
            Node attr = Objects.requireNonNull(attributes.getNamedItem(attributeName), String.format("Attribute '%s' not found.", attributeName));
            this.setLocation(attr, XmlFile.Location.NAME, currentLocation, attributeNameEnd);
            this.setLocation(attr, XmlFile.Location.VALUE, attributeValueStart, attributeValueEnd);
            this.setLocation(attr, XmlFile.Location.NODE, currentLocation, attributeValueEnd);
            currentLocation = attributeValueEnd.moveAfterWhitespaces();
        }
    }

    private List<PrologElement.PrologAttribute> visitPrologAttributes(XmlFilePosition start, XmlFilePosition end) throws XMLStreamException {
        XmlFilePosition currentLocation = start.moveAfterWhitespaces();
        ArrayList<PrologElement.PrologAttribute> attributes = new ArrayList<PrologElement.PrologAttribute>();
        while (currentLocation.has("=", end)) {
            XmlFilePosition attributeNameEnd = currentLocation.moveBefore("=");
            XmlFilePosition attributeValueStart = attributeNameEnd.moveAfter("=").moveAfterWhitespaces();
            char c = attributeValueStart.readChar();
            XmlFilePosition attributeValueEnd = attributeValueStart.shift(1).moveAfter(String.valueOf(c));
            attributes.add(new PrologElement.PrologAttribute(currentLocation.textUntil(attributeNameEnd), new XmlTextRange(currentLocation, attributeNameEnd, this.xmlFileStartLocation), XmlParser.removeQuotes(attributeValueStart.textUntil(attributeValueEnd)), new XmlTextRange(attributeValueStart, attributeValueEnd, this.xmlFileStartLocation)));
            currentLocation = attributeValueEnd.moveAfterWhitespaces();
        }
        return attributes;
    }

    private static String removeQuotes(String str) {
        if ((str.startsWith("\"") || str.startsWith("'")) && str.length() > 1) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    private static int getNameWithNamespaceLength(XMLStreamReader streamReader) {
        int prefixLength = 0;
        if (!streamReader.getName().getPrefix().isEmpty()) {
            prefixLength = streamReader.getName().getPrefix().length() + 1;
        }
        return prefixLength + streamReader.getLocalName().length();
    }
}

