/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.gradle;

import com.android.build.gradle.api.BaseVariant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.testing.jacoco.plugins.JacocoPlugin;
import org.gradle.testing.jacoco.tasks.JacocoReport;
import org.sonarqube.gradle.ActionBroadcast;
import org.sonarqube.gradle.AndroidUtils;
import org.sonarqube.gradle.SonarPropertyComputer;
import org.sonarqube.gradle.SonarQubeExtension;
import org.sonarqube.gradle.SonarQubeProperties;
import org.sonarqube.gradle.SonarQubeTask;
import org.sonarqube.gradle.SonarUtils;

public class SonarQubePlugin
implements Plugin<Project> {
    private static final Logger LOGGER = Logging.getLogger(SonarQubePlugin.class);

    private ActionBroadcast<SonarQubeProperties> addBroadcaster(Map<String, ActionBroadcast<SonarQubeProperties>> actionBroadcastMap, Project project) {
        ActionBroadcast<SonarQubeProperties> actionBroadcast = new ActionBroadcast<SonarQubeProperties>();
        actionBroadcastMap.put(project.getPath(), actionBroadcast);
        return actionBroadcast;
    }

    private static boolean addTaskByName(Project p, String name, List<Task> allCompileTasks) {
        try {
            allCompileTasks.add(p.getTasks().getByName(name));
            return true;
        }
        catch (UnknownTaskException e) {
            return false;
        }
    }

    public void apply(Project project) {
        if (project.getExtensions().findByName("sonarqube") == null) {
            HashMap<String, ActionBroadcast<SonarQubeProperties>> actionBroadcastMap = new HashMap<String, ActionBroadcast<SonarQubeProperties>>();
            this.addExtensions(project, actionBroadcastMap);
            LOGGER.debug("Adding sonarqube task to " + project);
            SonarQubeTask sonarQubeTask = (SonarQubeTask)project.getTasks().create("sonarqube", SonarQubeTask.class);
            sonarQubeTask.setDescription("Analyzes " + project + " and its subprojects with SonarQube.");
            this.configureTask(sonarQubeTask, project, actionBroadcastMap);
        }
    }

    private void addExtensions(Project project, Map<String, ActionBroadcast<SonarQubeProperties>> actionBroadcastMap) {
        project.getAllprojects().forEach(p -> {
            LOGGER.debug("Adding sonarqube extension to " + p);
            ActionBroadcast<SonarQubeProperties> actionBroadcast = this.addBroadcaster(actionBroadcastMap, (Project)p);
            p.getExtensions().create("sonarqube", SonarQubeExtension.class, new Object[]{actionBroadcast});
        });
    }

    private void configureTask(SonarQubeTask sonarQubeTask, Project project, Map<String, ActionBroadcast<SonarQubeProperties>> actionBroadcastMap) {
        ConventionMapping conventionMapping = sonarQubeTask.getConventionMapping();
        conventionMapping.map("properties", () -> new SonarPropertyComputer(actionBroadcastMap, project).computeSonarProperties());
        sonarQubeTask.mustRunAfter(new Object[]{SonarQubePlugin.getJavaTestTasks(project)});
        sonarQubeTask.dependsOn(new Object[]{SonarQubePlugin.getJavaCompileTasks(project)});
        sonarQubeTask.mustRunAfter(new Object[]{SonarQubePlugin.getJacocoTasks(project)});
        sonarQubeTask.dependsOn(new Object[]{SonarQubePlugin.getAndroidCompileTasks(project)});
    }

    private static Callable<Iterable<? extends Task>> getJacocoTasks(Project project) {
        return () -> project.getAllprojects().stream().filter(p -> p.getPlugins().hasPlugin(JacocoPlugin.class) && !((SonarQubeExtension)p.getExtensions().getByType(SonarQubeExtension.class)).isSkipProject()).map(p -> p.getTasks().withType(JacocoReport.class)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static Callable<Iterable<? extends Task>> getJavaTestTasks(Project project) {
        return () -> project.getAllprojects().stream().filter(p -> p.getPlugins().hasPlugin(JavaPlugin.class) && !((SonarQubeExtension)p.getExtensions().getByType(SonarQubeExtension.class)).isSkipProject()).map(p -> p.getTasks().getByName("test")).collect(Collectors.toList());
    }

    private static Callable<Iterable<? extends Task>> getJavaCompileTasks(Project project) {
        return () -> project.getAllprojects().stream().filter(p -> p.getPlugins().hasPlugin(JavaPlugin.class) && !((SonarQubeExtension)p.getExtensions().getByType(SonarQubeExtension.class)).isSkipProject()).flatMap(p -> Stream.of(p.getTasks().getByName("compileJava"), p.getTasks().getByName("compileTestJava"))).collect(Collectors.toList());
    }

    private static Callable<Iterable<? extends Task>> getAndroidCompileTasks(Project project) {
        return () -> project.getAllprojects().stream().filter(p -> SonarUtils.isAndroidProject(p) && !((SonarQubeExtension)p.getExtensions().getByType(SonarQubeExtension.class)).isSkipProject()).map(p -> {
            BaseVariant variant = AndroidUtils.findVariant(p, ((SonarQubeExtension)p.getExtensions().getByType(SonarQubeExtension.class)).getAndroidVariant());
            ArrayList<Task> allCompileTasks = new ArrayList<Task>();
            if (variant != null) {
                boolean unitTestTaskDepAdded = SonarQubePlugin.addTaskByName(p, "compile" + SonarUtils.capitalize(variant.getName()) + "UnitTestJavaWithJavac", allCompileTasks);
                boolean androidTestTaskDepAdded = SonarQubePlugin.addTaskByName(p, "compile" + SonarUtils.capitalize(variant.getName()) + "AndroidTestJavaWithJavac", allCompileTasks);
                if (!unitTestTaskDepAdded && !androidTestTaskDepAdded) {
                    SonarQubePlugin.addTaskByName(p, "compile" + SonarUtils.capitalize(variant.getName()) + "JavaWithJavac", allCompileTasks);
                }
            }
            return allCompileTasks;
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

