/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.gradle;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.gradle.api.Project;

public class SonarUtils {
    static boolean isAndroidProject(Project project) {
        return project.getPlugins().hasPlugin("com.android.application") || project.getPlugins().hasPlugin("com.android.library") || project.getPlugins().hasPlugin("com.android.test") || project.getPlugins().hasPlugin("com.android.feature");
    }

    static String capitalize(String word) {
        return Character.toUpperCase(word.charAt(0)) + word.substring(1);
    }

    static String findProjectBaseDir(Map<String, Object> properties) {
        Path rootBaseDir = Paths.get(properties.get("sonar.projectBaseDir").toString(), new String[0]).toAbsolutePath().normalize();
        List allProjectsBaseDir = properties.entrySet().stream().filter(e -> ((String)e.getKey()).endsWith(".projectBaseDir")).map(e -> Paths.get(e.getValue().toString(), new String[0])).collect(Collectors.toList());
        for (Path baseDir : allProjectsBaseDir) {
            Path normalizedBaseDir = baseDir.toAbsolutePath().normalize();
            if (!normalizedBaseDir.getRoot().equals(rootBaseDir.getRoot()) || normalizedBaseDir.startsWith(rootBaseDir)) continue;
            int c1 = normalizedBaseDir.getNameCount();
            int c2 = rootBaseDir.getNameCount();
            Path newBaseDir = rootBaseDir.getRoot();
            for (int i = 0; i < c1 && i < c2 && normalizedBaseDir.getName(i).equals(rootBaseDir.getName(i)); ++i) {
                newBaseDir = newBaseDir.resolve(rootBaseDir.getName(i));
            }
            rootBaseDir = newBaseDir;
        }
        return rootBaseDir.toString();
    }

    static void setTestClasspathProps(Map<String, Object> properties, Collection<File> testClassDirs, Collection<File> testLibraries) {
        SonarUtils.appendProps(properties, "sonar.java.test.binaries", SonarUtils.exists(testClassDirs));
        SonarUtils.appendProps(properties, "sonar.java.test.libraries", SonarUtils.exists(testLibraries));
    }

    static void setMainClasspathProps(Map<String, Object> properties, boolean addForGroovy, Collection<File> mainClassDirs, Collection<File> mainLibraries) {
        SonarUtils.appendProps(properties, "sonar.java.binaries", SonarUtils.exists(mainClassDirs));
        if (addForGroovy) {
            SonarUtils.appendProps(properties, "sonar.groovy.binaries", SonarUtils.exists(mainClassDirs));
        }
        SonarUtils.appendProps(properties, "sonar.binaries", SonarUtils.exists(mainClassDirs));
        SonarUtils.appendProps(properties, "sonar.java.libraries", SonarUtils.exists(mainLibraries));
        SonarUtils.appendProps(properties, "sonar.libraries", SonarUtils.exists(mainLibraries));
    }

    static List<File> exists(Collection<File> files) {
        return files.stream().filter(File::exists).collect(Collectors.toList());
    }

    static void appendProps(Map<String, Object> properties, String key, Iterable<?> valuesToAppend) {
        properties.putIfAbsent(key, new LinkedHashSet());
        StreamSupport.stream(valuesToAppend.spliterator(), false).forEach(v -> ((Collection)properties.get(key)).add(v.toString()));
    }

    static void appendProp(Map<String, Object> properties, String key, Object valueToAppend) {
        properties.putIfAbsent(key, new LinkedHashSet());
        ((Collection)properties.get(key)).add(valueToAppend.toString());
    }

    @Nullable
    static <T> List<T> nonEmptyOrNull(Collection<T> collection) {
        List<T> list = Collections.unmodifiableList(new ArrayList<T>(collection));
        return list.isEmpty() ? null : list;
    }
}

