/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.scm.svn;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.Plugin;
import org.sonar.plugins.scm.svn.FindFork;
import org.sonar.plugins.scm.svn.SvnBlameCommand;
import org.sonar.plugins.scm.svn.SvnConfiguration;
import org.sonar.plugins.scm.svn.SvnScmProvider;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public final class SvnPlugin
implements Plugin {
    static SVNClientManager newSvnClientManager(SvnConfiguration configuration) {
        DefaultSVNOptions options = SVNWCUtil.createDefaultOptions(true);
        char[] passwordValue = SvnPlugin.getCharsOrNull(configuration.password());
        char[] passPhraseValue = SvnPlugin.getCharsOrNull(configuration.passPhrase());
        ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager(null, configuration.username(), passwordValue, configuration.privateKey(), passPhraseValue, false);
        return SVNClientManager.newInstance((ISVNOptions)options, authManager);
    }

    @CheckForNull
    private static char[] getCharsOrNull(@Nullable String s) {
        return s != null ? s.toCharArray() : null;
    }

    public void define(Plugin.Context context) {
        context.addExtensions(SvnScmProvider.class, SvnBlameCommand.class, new Object[]{SvnConfiguration.class, FindFork.class});
        context.addExtensions(SvnConfiguration.getProperties());
    }
}

