/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks.utils;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.sonarsource.slang.api.FunctionDeclarationTree;
import org.sonarsource.slang.api.FunctionInvocationTree;
import org.sonarsource.slang.api.IdentifierTree;
import org.sonarsource.slang.api.MemberSelectTree;
import org.sonarsource.slang.api.ModifierTree;
import org.sonarsource.slang.api.StringLiteralTree;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.checks.utils.ExpressionUtils;

public class FunctionUtils {
    private FunctionUtils() {
    }

    public static boolean isPrivateMethod(FunctionDeclarationTree method) {
        return FunctionUtils.hasModifierMethod(method, ModifierTree.Kind.PRIVATE);
    }

    public static boolean isOverrideMethod(FunctionDeclarationTree method) {
        return FunctionUtils.hasModifierMethod(method, ModifierTree.Kind.OVERRIDE);
    }

    public static boolean hasModifierMethod(FunctionDeclarationTree method, ModifierTree.Kind kind) {
        return method.modifiers().stream().filter(ModifierTree.class::isInstance).map(ModifierTree.class::cast).anyMatch(modifier -> modifier.kind() == kind);
    }

    public static boolean hasFunctionCallNameIgnoreCase(FunctionInvocationTree tree, String name) {
        return FunctionUtils.getFunctionInvocationName(tree).filter(name::equalsIgnoreCase).isPresent();
    }

    public static Set<String> getStringsTokens(FunctionDeclarationTree functionDeclarationTree, String delimitersRegex) {
        HashSet<String> stringLiteralTokens = new HashSet<String>();
        functionDeclarationTree.descendants().filter(StringLiteralTree.class::isInstance).map(StringLiteralTree.class::cast).map(StringLiteralTree::content).forEach(literal -> stringLiteralTokens.addAll(Arrays.asList(literal.split(delimitersRegex))));
        return stringLiteralTokens;
    }

    private static Optional<String> getFunctionInvocationName(FunctionInvocationTree tree) {
        return ExpressionUtils.getMemberSelectOrIdentifierName(tree.memberSelect());
    }

    public static boolean hasFunctionCallFullNameIgnoreCase(FunctionInvocationTree tree, String ... names) {
        return FunctionUtils.hasFunctionCallFullNameIgnoreCaseHelper(tree.memberSelect(), Arrays.asList(names));
    }

    private static boolean hasFunctionCallFullNameIgnoreCaseHelper(Tree tree, List<String> names) {
        if (tree instanceof IdentifierTree) {
            return names.size() == 1 && ((IdentifierTree)tree).name().equalsIgnoreCase(names.get(0));
        }
        if (tree instanceof MemberSelectTree) {
            MemberSelectTree memberSelectTree = (MemberSelectTree)tree;
            return names.size() > 1 && memberSelectTree.identifier().name().equalsIgnoreCase(names.get(names.size() - 1)) && FunctionUtils.hasFunctionCallFullNameIgnoreCaseHelper(memberSelectTree.expression(), FunctionUtils.dropLastElement(names));
        }
        return false;
    }

    private static List<String> dropLastElement(List<String> list) {
        return list.subList(0, list.size() - 1);
    }
}

