/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.plugin;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonarsource.slang.api.BlockTree;
import org.sonarsource.slang.api.ClassDeclarationTree;
import org.sonarsource.slang.api.Comment;
import org.sonarsource.slang.api.FunctionDeclarationTree;
import org.sonarsource.slang.api.TopLevelTree;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.checks.complexity.CognitiveComplexity;
import org.sonarsource.slang.plugin.CommentAnalysisUtils;
import org.sonarsource.slang.plugin.CyclomaticComplexityVisitor;
import org.sonarsource.slang.plugin.InputFileContext;
import org.sonarsource.slang.plugin.StatementsVisitor;
import org.sonarsource.slang.visitors.TreeVisitor;

public class MetricVisitor
extends TreeVisitor<InputFileContext> {
    private final FileLinesContextFactory fileLinesContextFactory;
    private final Predicate<Tree> executableLineOfCodePredicate;
    private Set<Integer> linesOfCode;
    private Set<Integer> commentLines;
    private Set<Integer> executableLines;
    private int numberOfFunctions;
    private int numberOfClasses;
    private int complexity;
    private int statements;
    private int cognitiveComplexity;

    public MetricVisitor(FileLinesContextFactory fileLinesContextFactory, Predicate<Tree> executableLineOfCodePredicate) {
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.executableLineOfCodePredicate = executableLineOfCodePredicate;
        this.register(TopLevelTree.class, (ctx, tree) -> {
            List<Tree> declarations = tree.declarations();
            int firstTokenLine = declarations.isEmpty() ? tree.textRange().end().line() : declarations.get(0).textRange().start().line();
            tree.allComments().forEach(comment -> this.commentLines.addAll(MetricVisitor.findNonEmptyCommentLines(comment, firstTokenLine)));
            this.addExecutableLines(declarations);
            this.linesOfCode.addAll(tree.metaData().linesOfCode());
            this.complexity = new CyclomaticComplexityVisitor().complexityTrees((Tree)tree).size();
            this.statements = new StatementsVisitor().statements((Tree)tree);
            this.cognitiveComplexity = new CognitiveComplexity((Tree)tree).value();
        });
        this.register(FunctionDeclarationTree.class, (ctx, tree) -> {
            if (tree.name() != null && tree.body() != null) {
                ++this.numberOfFunctions;
            }
        });
        this.register(ClassDeclarationTree.class, (ctx, tree) -> ++this.numberOfClasses);
        this.register(BlockTree.class, (ctx, tree) -> this.addExecutableLines(tree.statementOrExpressions()));
    }

    static Set<Integer> findNonEmptyCommentLines(Comment comment, int firstTokenLine) {
        boolean isFileHeader;
        boolean bl = isFileHeader = comment.textRange().end().line() < firstTokenLine;
        if (!isFileHeader && !CommentAnalysisUtils.isNosonarComment(comment)) {
            return CommentAnalysisUtils.findNonEmptyCommentLines(comment.contentRange(), comment.contentText());
        }
        return Set.of();
    }

    private void addExecutableLines(List<Tree> trees) {
        trees.stream().filter(this.executableLineOfCodePredicate).forEach(t -> this.executableLines.add(t.metaData().textRange().start().line()));
    }

    @Override
    protected void before(InputFileContext ctx, Tree root) {
        this.linesOfCode = new HashSet<Integer>();
        this.commentLines = new HashSet<Integer>();
        this.executableLines = new HashSet<Integer>();
        this.numberOfFunctions = 0;
        this.numberOfClasses = 0;
        this.complexity = 0;
        this.cognitiveComplexity = 0;
    }

    @Override
    protected void after(InputFileContext ctx, Tree root) {
        MetricVisitor.saveMetric(ctx, (Metric<Integer>)CoreMetrics.NCLOC, this.linesOfCode().size());
        MetricVisitor.saveMetric(ctx, (Metric<Integer>)CoreMetrics.COMMENT_LINES, this.commentLines().size());
        MetricVisitor.saveMetric(ctx, (Metric<Integer>)CoreMetrics.FUNCTIONS, this.numberOfFunctions());
        MetricVisitor.saveMetric(ctx, (Metric<Integer>)CoreMetrics.CLASSES, this.numberOfClasses());
        MetricVisitor.saveMetric(ctx, (Metric<Integer>)CoreMetrics.COMPLEXITY, this.complexity);
        MetricVisitor.saveMetric(ctx, (Metric<Integer>)CoreMetrics.STATEMENTS, this.statements);
        MetricVisitor.saveMetric(ctx, (Metric<Integer>)CoreMetrics.COGNITIVE_COMPLEXITY, this.cognitiveComplexity);
        FileLinesContext fileLinesContext = this.fileLinesContextFactory.createFor(ctx.inputFile);
        this.linesOfCode().forEach(line -> fileLinesContext.setIntValue("ncloc_data", line.intValue(), 1));
        this.executableLines().forEach(line -> fileLinesContext.setIntValue("executable_lines_data", line.intValue(), 1));
        fileLinesContext.save();
    }

    private static void saveMetric(InputFileContext ctx, Metric<Integer> metric, Integer value) {
        ctx.sensorContext.newMeasure().on((InputComponent)ctx.inputFile).forMetric(metric).withValue((Serializable)value).save();
    }

    public Set<Integer> linesOfCode() {
        return this.linesOfCode;
    }

    public Set<Integer> commentLines() {
        return this.commentLines;
    }

    public Set<Integer> executableLines() {
        return this.executableLines;
    }

    public int numberOfFunctions() {
        return this.numberOfFunctions;
    }

    public int numberOfClasses() {
        return this.numberOfClasses;
    }

    public int cognitiveComplexity() {
        return this.cognitiveComplexity;
    }
}

