/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.plugin.caching;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.cache.ReadCache;
import org.sonar.api.batch.sensor.cache.WriteCache;
import org.sonarsource.slang.plugin.InputFileContext;

public class HashCacheUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HashCacheUtils.class);
    private static final String BYTES_TO_HEX_FORMAT = "%032X";

    private HashCacheUtils() {
    }

    public static boolean hasSameHashCached(InputFileContext inputFileContext) {
        byte[] expectedHashAsBytes;
        InputFile inputFile = inputFileContext.inputFile;
        String fileKey = inputFile.key();
        if (inputFile.status() != InputFile.Status.SAME) {
            LOG.debug("File {} is considered changed: file status is {}.", (Object)fileKey, (Object)inputFile.status());
            return false;
        }
        SensorContext sensorContext = inputFileContext.sensorContext;
        if (!sensorContext.isCacheEnabled()) {
            LOG.debug("File {} is considered changed: hash cache is disabled.", (Object)fileKey);
            return false;
        }
        String hashKey = HashCacheUtils.computeKey(inputFile);
        ReadCache previousCache = sensorContext.previousCache();
        if (!previousCache.contains(hashKey)) {
            LOG.debug("File {} is considered changed: hash could not be found in the cache.", (Object)fileKey);
            return false;
        }
        try (InputStream in = previousCache.read(hashKey);){
            expectedHashAsBytes = in.readAllBytes();
        }
        catch (IOException e) {
            LOG.debug("File {} is considered changed: failed to read hash from the cache.", (Object)fileKey);
            return false;
        }
        String expected = HashCacheUtils.md5sumBytesToHex(expectedHashAsBytes);
        String actual = inputFile.md5Hash();
        return expected.equals(actual);
    }

    public static boolean copyFromPrevious(InputFileContext inputFileContext) {
        if (!inputFileContext.sensorContext.isCacheEnabled()) {
            return false;
        }
        InputFile inputFile = inputFileContext.inputFile;
        String cacheKey = HashCacheUtils.computeKey(inputFile);
        WriteCache nextCache = inputFileContext.sensorContext.nextCache();
        try {
            nextCache.copyFromPrevious(cacheKey);
        }
        catch (IllegalArgumentException ignored) {
            LOG.warn("Failed to copy hash from previous analysis for {}.", (Object)inputFile.key());
            return false;
        }
        return true;
    }

    public static boolean writeHashForNextAnalysis(InputFileContext inputFileContext) {
        if (!inputFileContext.sensorContext.isCacheEnabled()) {
            return false;
        }
        InputFile inputFile = inputFileContext.inputFile;
        WriteCache nextCache = inputFileContext.sensorContext.nextCache();
        try {
            nextCache.write(HashCacheUtils.computeKey(inputFileContext.inputFile), inputFile.md5Hash().getBytes(StandardCharsets.UTF_8));
        }
        catch (IllegalArgumentException ignored) {
            LOG.warn("Failed to write hash for {} to cache.", (Object)inputFile.key());
            return false;
        }
        return true;
    }

    private static String computeKey(InputFile inputFile) {
        return "slang:hash:" + inputFile.key();
    }

    private static String md5sumBytesToHex(byte[] bytes) {
        BigInteger bi = new BigInteger(1, bytes);
        return BYTES_TO_HEX_FORMAT.formatted(bi).toLowerCase(Locale.getDefault());
    }
}

