/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonarsource.slang.api.BlockTree;
import org.sonarsource.slang.api.FunctionDeclarationTree;
import org.sonarsource.slang.api.HasTextRange;
import org.sonarsource.slang.api.IdentifierTree;
import org.sonarsource.slang.api.TextRange;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.api.TreeMetaData;
import org.sonarsource.slang.impl.BaseTreeImpl;
import org.sonarsource.slang.impl.TextRanges;

public class FunctionDeclarationTreeImpl
extends BaseTreeImpl
implements FunctionDeclarationTree {
    private final List<Tree> modifiers;
    private final boolean isConstructor;
    private final Tree returnType;
    private final IdentifierTree name;
    private final List<Tree> formalParameters;
    private final BlockTree body;
    private final List<Tree> children = new ArrayList<Tree>();
    private final List<Tree> nativeChildren;

    public FunctionDeclarationTreeImpl(TreeMetaData metaData, List<Tree> modifiers, boolean isConstructor, @Nullable Tree returnType, @Nullable IdentifierTree name, List<Tree> formalParameters, @Nullable BlockTree body, List<Tree> nativeChildren) {
        super(metaData);
        this.modifiers = modifiers;
        this.isConstructor = isConstructor;
        this.returnType = returnType;
        this.name = name;
        this.formalParameters = formalParameters;
        this.body = body;
        this.nativeChildren = nativeChildren;
        this.children.addAll(modifiers);
        if (returnType != null) {
            this.children.add(returnType);
        }
        if (name != null) {
            this.children.add(name);
        }
        this.children.addAll(formalParameters);
        if (body != null) {
            this.children.add(body);
        }
        this.children.addAll(nativeChildren);
    }

    @Override
    public List<Tree> modifiers() {
        return this.modifiers;
    }

    @Override
    public boolean isConstructor() {
        return this.isConstructor;
    }

    @Override
    @CheckForNull
    public Tree returnType() {
        return this.returnType;
    }

    @Override
    @CheckForNull
    public IdentifierTree name() {
        return this.name;
    }

    @Override
    public List<Tree> formalParameters() {
        return this.formalParameters;
    }

    @Override
    @CheckForNull
    public BlockTree body() {
        return this.body;
    }

    @Override
    public List<Tree> nativeChildren() {
        return this.nativeChildren;
    }

    @Override
    public TextRange rangeToHighlight() {
        if (this.name != null) {
            return this.name.metaData().textRange();
        }
        if (this.body == null) {
            return this.metaData().textRange();
        }
        TextRange bodyRange = this.body.metaData().textRange();
        List<TextRange> tokenRangesBeforeBody = this.metaData().tokens().stream().map(HasTextRange::textRange).filter(t -> t.start().compareTo(bodyRange.start()) < 0).collect(Collectors.toList());
        if (tokenRangesBeforeBody.isEmpty()) {
            return bodyRange;
        }
        return TextRanges.merge(tokenRangesBeforeBody);
    }

    @Override
    public List<Tree> children() {
        return this.children;
    }
}

