/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonarsource.slang.api.IdentifierTree;
import org.sonarsource.slang.api.ParameterTree;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.api.TreeMetaData;
import org.sonarsource.slang.impl.BaseTreeImpl;

public class ParameterTreeImpl
extends BaseTreeImpl
implements ParameterTree {
    private final IdentifierTree identifier;
    private final Tree type;
    private final Tree defaultValue;
    private final List<Tree> modifiers;

    public ParameterTreeImpl(TreeMetaData metaData, IdentifierTree identifier, @Nullable Tree type, @Nullable Tree defaultValue, List<Tree> modifiers) {
        super(metaData);
        this.identifier = identifier;
        this.type = type;
        this.defaultValue = defaultValue;
        this.modifiers = modifiers;
    }

    public ParameterTreeImpl(TreeMetaData metaData, IdentifierTree identifier, @Nullable Tree type, @Nullable Tree defaultValue) {
        this(metaData, identifier, type, defaultValue, Collections.emptyList());
    }

    public ParameterTreeImpl(TreeMetaData metaData, IdentifierTree identifier, @Nullable Tree type) {
        this(metaData, identifier, type, null);
    }

    @Override
    public IdentifierTree identifier() {
        return this.identifier;
    }

    @Override
    @CheckForNull
    public Tree type() {
        return this.type;
    }

    @Override
    @CheckForNull
    public Tree defaultValue() {
        return this.defaultValue;
    }

    @Override
    public List<Tree> modifiers() {
        return this.modifiers;
    }

    @Override
    public List<Tree> children() {
        ArrayList<Tree> children = new ArrayList<Tree>();
        children.addAll(this.modifiers);
        children.add(this.identifier);
        if (this.type != null) {
            children.add(this.type);
        }
        if (this.defaultValue != null) {
            children.add(this.defaultValue);
        }
        return children;
    }
}

