/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.visitors;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.visitors.TreeContext;

public class TreeVisitor<C extends TreeContext> {
    private List<ConsumerFilter<C, ?>> consumers = null;

    public void scan(C ctx, @Nullable Tree root) {
        if (root != null) {
            ((TreeContext)ctx).before(root);
            this.before(ctx, root);
            this.visit(ctx, root);
            this.after(ctx, root);
        }
    }

    private void visit(C ctx, @Nullable Tree node) {
        if (node != null) {
            ((TreeContext)ctx).enter(node);
            if (this.consumers != null) {
                for (ConsumerFilter<C, ?> consumer : this.consumers) {
                    ((ConsumerFilter)consumer).accept(ctx, node);
                }
            }
            node.children().forEach(child -> this.visit(ctx, (Tree)child));
            ((TreeContext)ctx).leave(node);
        }
    }

    protected void before(C ctx, Tree root) {
    }

    protected void after(C ctx, Tree root) {
    }

    public <T extends Tree> TreeVisitor<C> register(Class<T> cls, BiConsumer<C, T> visitor) {
        if (this.consumers == null) {
            this.consumers = new ArrayList();
        }
        this.consumers.add(new ConsumerFilter(cls, visitor));
        return this;
    }

    private static class ConsumerFilter<C extends TreeContext, T extends Tree> {
        private final Class<T> cls;
        private final BiConsumer<C, T> delegate;

        private ConsumerFilter(Class<T> cls, BiConsumer<C, T> delegate) {
            this.cls = cls;
            this.delegate = delegate;
        }

        private void accept(C ctx, Tree node) {
            if (this.cls.isAssignableFrom(node.getClass())) {
                this.delegate.accept(ctx, (Tree)this.cls.cast(node));
            }
        }
    }
}

