/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.plugin;

import java.util.List;
import org.sonar.api.batch.sensor.cpd.NewCpdTokens;
import org.sonarsource.slang.api.Token;
import org.sonarsource.slang.api.TopLevelTree;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.plugin.InputFileContext;
import org.sonarsource.slang.visitors.TreeVisitor;

public class CpdVisitor
extends TreeVisitor<InputFileContext> {
    private NewCpdTokens cpdTokens;

    public CpdVisitor() {
        this.register(TopLevelTree.class, (ctx, tree) -> {
            List<Token> tokens = tree.metaData().tokens();
            boolean foundFirstToken = tree.firstCpdToken() == null;
            for (Token token : tokens) {
                if (!(foundFirstToken = foundFirstToken || token == tree.firstCpdToken())) continue;
                String text = token.type() == Token.Type.STRING_LITERAL ? "LITERAL" : token.text();
                this.cpdTokens.addToken(ctx.textRange(token.textRange()), text);
            }
        });
    }

    @Override
    protected void before(InputFileContext ctx, Tree root2) {
        this.cpdTokens = ctx.sensorContext.newCpdTokens().onFile(ctx.inputFile);
    }

    @Override
    protected void after(InputFileContext ctx, Tree root2) {
        this.cpdTokens.save();
    }
}

