/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scala.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.coverage.NewCoverage;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonarsource.analyzer.commons.xml.SafeStaxParserFactory;
import org.sonarsource.slang.plugin.AbstractPropertyHandlerSensor;

public class ScoverageSensor
extends AbstractPropertyHandlerSensor {
    private static final QName STATEMENT_ELEMENT = new QName("statement");
    private static final QName INVOCATION_COUNT_ATTRIBUTE = new QName("invocation-count");
    private static final QName LINE_ATTRIBUTE = new QName("line");
    private static final QName SOURCE_ATTRIBUTE = new QName("source");
    private static final Logger LOG = LoggerFactory.getLogger(ScoverageSensor.class);
    private static final int MAX_LOGGED_FILE_NAMES = 20;
    private final Set<String> unresolvedInputFile = new HashSet<String>();

    public ScoverageSensor(AnalysisWarnings analysisWarnings) {
        super(analysisWarnings, "scoverage", "Scoverage", "sonar.scala.coverage.reportPaths", "scala");
    }

    @Override
    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("scala").onlyWhenConfiguration(conf -> conf.hasKey("sonar.scala.coverage.reportPaths")).name("Scoverage sensor for Scala coverage");
    }

    @Override
    public Consumer<File> reportConsumer(SensorContext context) {
        return file -> ScoverageSensor.readReportFile(file, context, this.unresolvedInputFile);
    }

    @Override
    public void execute(SensorContext context) {
        this.unresolvedInputFile.clear();
        super.execute(context);
        ScoverageSensor.logUnresolvedInputFiles(this.unresolvedInputFile);
    }

    private static void readReportFile(File file, SensorContext context, Set<String> unresolvedInputFile) {
        HashMap<String, Map<Integer, Integer>> linesHitPerFiles = new HashMap<String, Map<Integer, Integer>>();
        try (FileInputStream in = new FileInputStream(file);){
            XMLEventReader reader = SafeStaxParserFactory.createXMLInputFactory().createXMLEventReader(in);
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (!event.isStartElement() || !STATEMENT_ELEMENT.equals(event.asStartElement().getName())) continue;
                ScoverageSensor.parseStatementAttributes(linesHitPerFiles, event.asStartElement());
            }
            ScoverageSensor.addLineHitToContext(linesHitPerFiles, context, unresolvedInputFile);
        }
        catch (IOException | NumberFormatException | XMLStreamException e) {
            LOG.error("File '{}' can't be read. " + e.toString(), (Object)file, (Object)e);
        }
    }

    private static void parseStatementAttributes(Map<String, Map<Integer, Integer>> linesHitPerFiles, StartElement currentEvent) {
        Integer line = Integer.valueOf(ScoverageSensor.getAttributeValue(currentEvent, LINE_ATTRIBUTE));
        Integer invocationCount = Integer.valueOf(ScoverageSensor.getAttributeValue(currentEvent, INVOCATION_COUNT_ATTRIBUTE));
        String source = ScoverageSensor.getAttributeValue(currentEvent, SOURCE_ATTRIBUTE);
        if (source == null) {
            throw new IllegalStateException("Source attribute is null.");
        }
        linesHitPerFiles.computeIfAbsent(source, key -> new HashMap()).merge(line, invocationCount, Integer::sum);
    }

    private static String getAttributeValue(StartElement element, QName attributeName) {
        Attribute attribute = element.getAttributeByName(attributeName);
        return attribute != null ? attribute.getValue() : null;
    }

    private static void addLineHitToContext(Map<String, Map<Integer, Integer>> linesHitPerFiles, SensorContext context, Set<String> unresolvedInputFile) {
        FilePredicates predicates = context.fileSystem().predicates();
        for (Map.Entry<String, Map<Integer, Integer>> entry : linesHitPerFiles.entrySet()) {
            String sourcePath = entry.getKey();
            InputFile inputFile = context.fileSystem().inputFile(predicates.hasAbsolutePath(sourcePath));
            if (inputFile == null) {
                unresolvedInputFile.add(sourcePath);
                continue;
            }
            NewCoverage newCoverage = context.newCoverage().onFile(inputFile);
            for (Map.Entry<Integer, Integer> hitCount : entry.getValue().entrySet()) {
                newCoverage.lineHits(hitCount.getKey().intValue(), hitCount.getValue().intValue());
            }
            newCoverage.save();
        }
    }

    private static void logUnresolvedInputFiles(Set<String> unresolvedInputFile) {
        if (unresolvedInputFile.isEmpty()) {
            return;
        }
        Object fileList = unresolvedInputFile.stream().sorted().limit(20L).collect(Collectors.joining(";"));
        if (unresolvedInputFile.size() > 20) {
            fileList = (String)fileList + ";...";
        }
        LOG.warn("Fail to resolve {} file(s). No coverage data will be imported on the following file(s): {}", (Object)unresolvedInputFile.size(), fileList);
    }
}

