/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.slang.api.FunctionDeclarationTree;
import org.sonarsource.slang.api.HasTextRange;
import org.sonarsource.slang.api.ModifierTree;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SecondaryLocation;
import org.sonarsource.slang.checks.api.SlangCheck;

@Rule(key="S107")
public class TooManyParametersCheck
implements SlangCheck {
    private static final int DEFAULT_MAX = 7;
    @RuleProperty(key="Max", description="Maximum authorized number of parameters", defaultValue="7")
    public int max = 7;

    @Override
    public void initialize(InitContext init) {
        init.register(FunctionDeclarationTree.class, (ctx, tree) -> {
            if (this.isCandidateMethod((FunctionDeclarationTree)tree)) {
                String message = String.format("This function has %s parameters, which is greater than the %s authorized.", tree.formalParameters().size(), this.max);
                List<SecondaryLocation> secondaryLocations = tree.formalParameters().stream().skip(this.max).map(SecondaryLocation::new).toList();
                if (tree.name() == null) {
                    ctx.reportIssue((HasTextRange)tree, message, secondaryLocations);
                } else {
                    ctx.reportIssue((HasTextRange)tree.name(), message, secondaryLocations);
                }
            }
        });
    }

    protected boolean isCandidateMethod(FunctionDeclarationTree functionDeclarationTree) {
        return !functionDeclarationTree.isConstructor() && !TooManyParametersCheck.isOverrideMethod(functionDeclarationTree) && functionDeclarationTree.formalParameters().size() > this.max;
    }

    private static boolean isOverrideMethod(FunctionDeclarationTree tree) {
        return tree.modifiers().stream().anyMatch(mod -> {
            if (!(mod instanceof ModifierTree)) {
                return false;
            }
            return ((ModifierTree)mod).kind() == ModifierTree.Kind.OVERRIDE;
        });
    }
}

